/*
 * Decompiled with CFR 0.152.
 */
package com.proton.bluetooth.receiver.listener;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;

public abstract class AbsBluetoothListener
implements Handler.Callback {
    private static final int MSG_INVOKE = 1;
    private static final int MSG_SYNC_INVOKE = 2;
    private Handler mHandler;
    private Handler mSyncHandler;

    public AbsBluetoothListener() {
        if (Looper.myLooper() == null) {
            throw new IllegalStateException();
        }
        this.mHandler = new Handler(Looper.myLooper(), (Handler.Callback)this);
        this.mSyncHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    }

    public boolean handleMessage(Message msg) {
        Object[] args = (Object[])msg.obj;
        switch (msg.what) {
            case 1: {
                this.onInvoke(args);
                break;
            }
            case 2: {
                this.onSyncInvoke(args);
            }
        }
        return true;
    }

    public final void invoke(Object ... args) {
        this.mHandler.obtainMessage(1, (Object)args).sendToTarget();
    }

    public final void invokeSync(Object ... args) {
        this.mSyncHandler.obtainMessage(2, (Object)args).sendToTarget();
    }

    public abstract void onInvoke(Object ... var1);

    public abstract void onSyncInvoke(Object ... var1);
}

