/*
 * Decompiled with CFR 0.152.
 */
package com.proton.bluetooth.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.proton.bluetooth.receiver.AbsBluetoothReceiver;
import com.proton.bluetooth.receiver.BleCharacterChangeReceiver;
import com.proton.bluetooth.receiver.BleConnectStatusChangeReceiver;
import com.proton.bluetooth.receiver.BluetoothBondReceiver;
import com.proton.bluetooth.receiver.BluetoothStateReceiver;
import com.proton.bluetooth.receiver.IBluetoothReceiver;
import com.proton.bluetooth.receiver.IReceiverDispatcher;
import com.proton.bluetooth.receiver.listener.BluetoothReceiverListener;
import com.proton.bluetooth.utils.Logger;
import com.proton.bluetooth.utils.Utils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BluetoothReceiver
extends BroadcastReceiver
implements IBluetoothReceiver,
Handler.Callback {
    private static final int MSG_REGISTER = 1;
    private Map<String, List<BluetoothReceiverListener>> mListeners;
    private static IBluetoothReceiver mReceiver;
    private Handler mHandler;
    private IReceiverDispatcher mDispatcher = new IReceiverDispatcher(){

        @Override
        public List<BluetoothReceiverListener> getListeners(Class<?> clazz) {
            return (List)BluetoothReceiver.this.mListeners.get(clazz.getSimpleName());
        }
    };
    private AbsBluetoothReceiver[] RECEIVERS = new AbsBluetoothReceiver[]{BluetoothStateReceiver.newInstance(this.mDispatcher), BluetoothBondReceiver.newInstance(this.mDispatcher), BleConnectStatusChangeReceiver.newInstance(this.mDispatcher), BleCharacterChangeReceiver.newInstance(this.mDispatcher)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IBluetoothReceiver getInstance() {
        if (mReceiver != null) return mReceiver;
        Class<BluetoothReceiver> clazz = BluetoothReceiver.class;
        synchronized (BluetoothReceiver.class) {
            if (mReceiver != null) return mReceiver;
            mReceiver = new BluetoothReceiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mReceiver;
        }
    }

    private BluetoothReceiver() {
        this.mListeners = new HashMap<String, List<BluetoothReceiverListener>>();
        this.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        Utils.registerReceiver(this, this.getIntentFilter());
    }

    private IntentFilter getIntentFilter() {
        IntentFilter filter = new IntentFilter();
        for (AbsBluetoothReceiver receiver : this.RECEIVERS) {
            List<String> actions = receiver.getActions();
            for (String action : actions) {
                filter.addAction(action);
            }
        }
        return filter;
    }

    public void onReceive(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        String action = intent.getAction();
        if (TextUtils.isEmpty((CharSequence)action)) {
            return;
        }
        Logger.v(String.format("BluetoothReceiver onReceive: %s", action));
        for (AbsBluetoothReceiver receiver : this.RECEIVERS) {
            if (!receiver.containsAction(action) || !receiver.onReceive(context, intent)) continue;
            return;
        }
    }

    @Override
    public void register(BluetoothReceiverListener listener) {
        this.mHandler.obtainMessage(1, (Object)listener).sendToTarget();
    }

    private void registerInner(BluetoothReceiverListener listener) {
        if (listener != null) {
            List<BluetoothReceiverListener> listeners = this.mListeners.get(listener.getName());
            if (listeners == null) {
                listeners = new LinkedList<BluetoothReceiverListener>();
                this.mListeners.put(listener.getName(), listeners);
            }
            listeners.add(listener);
        }
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.registerInner((BluetoothReceiverListener)msg.obj);
            }
        }
        return true;
    }
}

