/*
 * Decompiled with CFR 0.152.
 */
package com.proton.bluetooth.receiver;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.Intent;
import com.proton.bluetooth.receiver.AbsBluetoothReceiver;
import com.proton.bluetooth.receiver.IReceiverDispatcher;
import com.proton.bluetooth.receiver.listener.BluetoothBondStateChangeListener;
import com.proton.bluetooth.receiver.listener.BluetoothReceiverListener;
import java.util.Arrays;
import java.util.List;

public class BluetoothBondReceiver
extends AbsBluetoothReceiver {
    private static final String[] ACTIONS = new String[]{"android.bluetooth.device.action.BOND_STATE_CHANGED"};

    protected BluetoothBondReceiver(IReceiverDispatcher dispatcher) {
        super(dispatcher);
    }

    public static BluetoothBondReceiver newInstance(IReceiverDispatcher dispatcher) {
        return new BluetoothBondReceiver(dispatcher);
    }

    @Override
    List<String> getActions() {
        return Arrays.asList(ACTIONS);
    }

    @Override
    boolean onReceive(Context context, Intent intent) {
        BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
        int state = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", -1);
        if (device != null) {
            this.onBondStateChanged(device.getAddress(), state);
        }
        return true;
    }

    private void onBondStateChanged(String mac, int bondState) {
        List<BluetoothReceiverListener> listeners = this.getListeners(BluetoothBondStateChangeListener.class);
        for (BluetoothReceiverListener listener : listeners) {
            listener.invoke(mac, bondState);
        }
    }
}

