/*
 * Decompiled with CFR 0.152.
 */
package com.proton.bluetooth.connect.request;

import android.bluetooth.BluetoothGattCharacteristic;
import com.proton.bluetooth.connect.listener.WriteCharacterListener;
import com.proton.bluetooth.connect.request.BleRequest;
import com.proton.bluetooth.connect.response.BleGeneralResponse;
import java.util.UUID;

public class BleWriteNoRspRequest
extends BleRequest
implements WriteCharacterListener {
    private UUID mServiceUUID;
    private UUID mCharacterUUID;
    private byte[] mBytes;

    public BleWriteNoRspRequest(UUID service, UUID character, byte[] bytes, BleGeneralResponse response) {
        super(response);
        this.mServiceUUID = service;
        this.mCharacterUUID = character;
        this.mBytes = bytes;
    }

    @Override
    public void processRequest() {
        switch (this.getCurrentStatus()) {
            case 0: {
                this.onRequestCompleted(-1);
                break;
            }
            case 2: {
                this.startWrite();
                break;
            }
            case 19: {
                this.startWrite();
                break;
            }
            default: {
                this.onRequestCompleted(-1);
            }
        }
    }

    private void startWrite() {
        if (!this.writeCharacteristicWithNoRsp(this.mServiceUUID, this.mCharacterUUID, this.mBytes)) {
            this.onRequestCompleted(-1);
        } else {
            this.startRequestTiming();
        }
    }

    @Override
    public void onCharacteristicWrite(BluetoothGattCharacteristic characteristic, int status, byte[] value) {
        this.stopRequestTiming();
        if (status == 0) {
            this.onRequestCompleted(0);
        } else {
            this.onRequestCompleted(-1);
        }
    }
}

