/*
 * Decompiled with CFR 0.152.
 */
package com.proton.bluetooth.connect;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.proton.bluetooth.RuntimeChecker;
import com.proton.bluetooth.connect.BleConnectWorker;
import com.proton.bluetooth.connect.IBleConnectDispatcher;
import com.proton.bluetooth.connect.IBleConnectWorker;
import com.proton.bluetooth.connect.options.BleConnectOptions;
import com.proton.bluetooth.connect.request.BleConnectRequest;
import com.proton.bluetooth.connect.request.BleIndicateRequest;
import com.proton.bluetooth.connect.request.BleMtuRequest;
import com.proton.bluetooth.connect.request.BleNotifyRequest;
import com.proton.bluetooth.connect.request.BleReadDescriptorRequest;
import com.proton.bluetooth.connect.request.BleReadRequest;
import com.proton.bluetooth.connect.request.BleReadRssiRequest;
import com.proton.bluetooth.connect.request.BleRefreshCacheRequest;
import com.proton.bluetooth.connect.request.BleRequest;
import com.proton.bluetooth.connect.request.BleUnnotifyRequest;
import com.proton.bluetooth.connect.request.BleWriteDescriptorRequest;
import com.proton.bluetooth.connect.request.BleWriteNoRspRequest;
import com.proton.bluetooth.connect.request.BleWriteRequest;
import com.proton.bluetooth.connect.response.BleGeneralResponse;
import com.proton.bluetooth.utils.ListUtils;
import com.proton.bluetooth.utils.Logger;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public class BleConnectDispatcher
implements IBleConnectDispatcher,
RuntimeChecker,
Handler.Callback {
    private static final int MAX_REQUEST_COUNT = 100;
    private static final int MSG_SCHEDULE_NEXT = 18;
    private List<BleRequest> mBleWorkList;
    private BleRequest mCurrentRequest;
    private IBleConnectWorker mWorker;
    private String mAddress;
    private Handler mHandler;

    public static BleConnectDispatcher newInstance(String mac) {
        return new BleConnectDispatcher(mac);
    }

    private BleConnectDispatcher(String mac) {
        this.mAddress = mac;
        this.mBleWorkList = new LinkedList<BleRequest>();
        this.mWorker = new BleConnectWorker(mac, this);
        this.mHandler = new Handler(Looper.myLooper(), (Handler.Callback)this);
    }

    public void connect(BleConnectOptions options, BleGeneralResponse response) {
        this.addNewRequest(new BleConnectRequest(options, response));
    }

    public void disconnect() {
        this.checkRuntime();
        Logger.w(String.format("Process disconnect", new Object[0]));
        if (this.mCurrentRequest != null) {
            this.mCurrentRequest.cancel();
            this.mCurrentRequest = null;
        }
        for (BleRequest request : this.mBleWorkList) {
            request.cancel();
        }
        this.mBleWorkList.clear();
        this.mWorker.closeGatt();
    }

    public void refreshCache() {
        this.addNewRequest(new BleRefreshCacheRequest(null));
    }

    public void clearRequest(int clearType) {
        this.checkRuntime();
        Logger.w(String.format("clearRequest %d", clearType));
        LinkedList<BleRequest> requestClear = new LinkedList<BleRequest>();
        if (clearType == 0) {
            requestClear.addAll(this.mBleWorkList);
        } else {
            for (BleRequest request : this.mBleWorkList) {
                if (!this.isRequestMatch(request, clearType)) continue;
                requestClear.add(request);
            }
        }
        for (BleRequest request : requestClear) {
            request.cancel();
        }
        this.mBleWorkList.removeAll(requestClear);
    }

    private boolean isRequestMatch(BleRequest request, int requestType) {
        if ((requestType & 1) != 0) {
            return request instanceof BleReadRequest;
        }
        if ((requestType & 2) != 0) {
            return request instanceof BleWriteRequest || request instanceof BleWriteNoRspRequest;
        }
        if ((requestType & 4) != 0) {
            return request instanceof BleNotifyRequest || request instanceof BleUnnotifyRequest || request instanceof BleIndicateRequest;
        }
        if ((requestType & 8) != 0) {
            return request instanceof BleReadRssiRequest;
        }
        return false;
    }

    public void read(UUID service, UUID character, BleGeneralResponse response) {
        this.addNewRequest(new BleReadRequest(service, character, response));
    }

    public void write(UUID service, UUID character, byte[] bytes, BleGeneralResponse response) {
        this.addNewRequest(new BleWriteRequest(service, character, bytes, response));
    }

    public void writeNoRsp(UUID service, UUID character, byte[] bytes, BleGeneralResponse response) {
        this.addNewRequest(new BleWriteNoRspRequest(service, character, bytes, response));
    }

    public void readDescriptor(UUID service, UUID character, UUID descriptor, BleGeneralResponse response) {
        this.addNewRequest(new BleReadDescriptorRequest(service, character, descriptor, response));
    }

    public void writeDescriptor(UUID service, UUID character, UUID descriptor, byte[] bytes, BleGeneralResponse response) {
        this.addNewRequest(new BleWriteDescriptorRequest(service, character, descriptor, bytes, response));
    }

    public void notify(UUID service, UUID character, BleGeneralResponse response) {
        this.addNewRequest(new BleNotifyRequest(service, character, response));
    }

    public void unnotify(UUID service, UUID character, BleGeneralResponse response) {
        this.addNewRequest(new BleUnnotifyRequest(service, character, response));
    }

    public void indicate(UUID service, UUID character, BleGeneralResponse response) {
        this.addNewRequest(new BleIndicateRequest(service, character, response));
    }

    public void unindicate(UUID service, UUID character, BleGeneralResponse response) {
        this.addNewRequest(new BleUnnotifyRequest(service, character, response));
    }

    public void readRemoteRssi(BleGeneralResponse response) {
        this.addNewRequest(new BleReadRssiRequest(response));
    }

    public void requestMtu(int mtu, BleGeneralResponse response) {
        this.addNewRequest(new BleMtuRequest(mtu, response));
    }

    private void addNewRequest(BleRequest request) {
        this.checkRuntime();
        if (this.mBleWorkList.size() < 100) {
            request.setRuntimeChecker(this);
            request.setAddress(this.mAddress);
            request.setWorker(this.mWorker);
            this.mBleWorkList.add(request);
        } else {
            request.onResponse(-8);
        }
        this.scheduleNextRequest(10L);
    }

    @Override
    public void onRequestCompleted(BleRequest request) {
        this.checkRuntime();
        if (request != this.mCurrentRequest) {
            throw new IllegalStateException("request not match");
        }
        this.mCurrentRequest = null;
        this.scheduleNextRequest(10L);
    }

    private void scheduleNextRequest(long delayInMillis) {
        this.mHandler.sendEmptyMessageDelayed(18, delayInMillis);
    }

    private void scheduleNextRequest() {
        if (this.mCurrentRequest != null) {
            return;
        }
        if (!ListUtils.isEmpty(this.mBleWorkList)) {
            this.mCurrentRequest = this.mBleWorkList.remove(0);
            this.mCurrentRequest.process(this);
        }
    }

    @Override
    public void checkRuntime() {
        if (Thread.currentThread() != this.mHandler.getLooper().getThread()) {
            throw new IllegalStateException("Thread Context Illegal");
        }
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 18: {
                this.scheduleNextRequest();
            }
        }
        return true;
    }
}

