package com.proton.bluetooth.search.le;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter.LeScanCallback;
import android.bluetooth.BluetoothDevice;
import android.os.Build;

import com.proton.bluetooth.search.BluetoothSearcher;
import com.proton.bluetooth.search.SearchResult;
import com.proton.bluetooth.search.response.BluetoothSearchResponse;
import com.proton.bluetooth.utils.Logger;
import com.proton.bluetooth.utils.Utils;

/**
 * @author proton
 */
public class BluetoothLESearcher extends BluetoothSearcher {

    private BluetoothLESearcher() {
        mBluetoothAdapter = Utils.getBluetoothAdapter();
    }

    public static BluetoothLESearcher getInstance() {
        return BluetoothLESearcherHolder.instance;
    }

    private static class BluetoothLESearcherHolder {
        private static BluetoothLESearcher instance = new BluetoothLESearcher();
    }

    @Override
    public void startScanBluetooth(final BluetoothSearchResponse response) {
        super.startScanBluetooth(response);
        mBluetoothAdapter.startLeScan(mLeScanCallback);
    }

    @TargetApi(Build.VERSION_CODES.JELLY_BEAN_MR2)
    @SuppressWarnings("deprecation")
    @Override
    public void stopScanBluetooth() {
        try {
            mBluetoothAdapter.stopLeScan(mLeScanCallback);
        } catch (Exception e) {
            Logger.e(e);
        }
        super.stopScanBluetooth();
    }

    @TargetApi(Build.VERSION_CODES.JELLY_BEAN_MR2)
    @SuppressWarnings("deprecation")
    @Override
    protected void cancelScanBluetooth() {
        mBluetoothAdapter.stopLeScan(mLeScanCallback);
        super.cancelScanBluetooth();
    }

    private final LeScanCallback mLeScanCallback = new LeScanCallback() {
        @Override
        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            notifyDeviceFounded(new SearchResult(device, rssi, scanRecord));
        }
    };
}
