/*
 * Decompiled with CFR 0.152.
 */
package com.wjj.easy.qrcodestyle;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;

public class QRCodeStyleUtils {
    public static Bitmap zoom(Bitmap bitmap, int radius) {
        Matrix m = new Matrix();
        float sx = 2.0f * (float)radius / (float)bitmap.getWidth();
        float sy = 2.0f * (float)radius / (float)bitmap.getHeight();
        m.setScale(sx, sy);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)m, (boolean)false);
    }

    public static Bitmap setCircle(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        Bitmap target = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(target);
        canvas.drawCircle((float)(width / 2), (float)(height / 2), (float)((width <= height ? width : height) / 2), paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        return target;
    }

    public static Bitmap setCircleSpace(Bitmap bitmap, int space) {
        int width = bitmap.getWidth() + space * 2;
        int height = bitmap.getHeight() + space * 2;
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        Bitmap target = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(target);
        canvas.save();
        canvas.drawCircle((float)(width / 2), (float)(width / 2), (float)(width / 2), paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        paint.setColor(-1);
        paint.setStyle(Paint.Style.FILL);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)height, paint);
        paint.setXfermode(null);
        canvas.restore();
        canvas.drawBitmap(bitmap, (float)space, (float)space, paint);
        return target;
    }

    public static Bitmap mergeBitmap(Bitmap small, Bitmap big) {
        Bitmap target = Bitmap.createBitmap((int)big.getWidth(), (int)big.getHeight(), (Bitmap.Config)big.getConfig());
        Canvas canvas = new Canvas(target);
        canvas.drawBitmap(big, new Matrix(), null);
        int left = (big.getWidth() - small.getWidth()) / 2;
        int top = (big.getHeight() - small.getHeight()) / 2;
        canvas.drawBitmap(small, (float)left, (float)top, null);
        return target;
    }

    public static Bitmap mask(Bitmap mask, Bitmap qr) {
        int width = qr.getWidth();
        int height = qr.getHeight();
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        Bitmap target = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(target);
        canvas.save();
        canvas.drawBitmap(qr, 0.0f, 0.0f, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(mask, new Rect(0, 0, mask.getWidth(), mask.getHeight()), new Rect(0, 0, width, height), paint);
        paint.setXfermode(null);
        canvas.restore();
        return target;
    }
}

