/*
 * Decompiled with CFR 0.152.
 */
package com.wjj.easy.qrcodestyle;

import android.graphics.Bitmap;
import com.wjj.easy.qrcodestyle.QRCodeStyleUtils;

public class QRCodeStyle {
    private Bitmap qrBitmap;
    private Bitmap logoBitmap;
    private Bitmap targetBitmap;
    private int radius;
    private boolean isCircle;
    private int space;
    private Bitmap maskBitmap;
    private Bitmap bgBitmap;
    Builder builder;

    private QRCodeStyle(Builder builder) {
        this.builder = builder;
        this.logoBitmap = builder.logoBitmap;
        this.radius = builder.radius;
        this.isCircle = builder.isCircle;
        this.space = builder.space;
        this.qrBitmap = builder.qrBitmap;
        this.maskBitmap = builder.maskBitmap;
        this.bgBitmap = builder.bgBitmap;
        if (this.qrBitmap == null) {
            throw new RuntimeException("must provide qr code bitmap!");
        }
        if (this.logoBitmap != null && this.radius != 0) {
            this.logoBitmap = QRCodeStyleUtils.zoom(this.logoBitmap, this.radius);
        }
        if (this.logoBitmap != null && this.isCircle) {
            this.logoBitmap = QRCodeStyleUtils.setCircle(this.logoBitmap);
        }
        if (this.logoBitmap != null && this.isCircle && this.space != 0) {
            this.logoBitmap = QRCodeStyleUtils.setCircleSpace(this.logoBitmap, this.space);
        }
        if (this.logoBitmap != null) {
            this.targetBitmap = QRCodeStyleUtils.mergeBitmap(this.logoBitmap, this.qrBitmap);
        }
        if (this.maskBitmap != null) {
            this.targetBitmap = QRCodeStyleUtils.mask(this.maskBitmap, this.qrBitmap);
        }
        if (this.bgBitmap != null) {
            this.targetBitmap = QRCodeStyleUtils.mergeBitmap(this.targetBitmap == null ? this.qrBitmap : this.targetBitmap, this.bgBitmap);
        }
    }

    public Bitmap get() {
        return this.targetBitmap;
    }

    public static class Builder {
        private Bitmap logoBitmap;
        private int radius;
        private boolean isCircle;
        private int space;
        private Bitmap qrBitmap;
        private Bitmap maskBitmap;
        private Bitmap bgBitmap;

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public QRCodeStyle build() {
            return new QRCodeStyle(this);
        }

        public Builder setLogo(Bitmap logoBitmap) {
            this.logoBitmap = logoBitmap;
            return this;
        }

        public Builder setRadius(int radius) {
            this.radius = radius;
            return this;
        }

        public Builder setCircle(boolean circle) {
            this.isCircle = circle;
            return this;
        }

        public Builder setSpace(int space) {
            this.space = space;
            return this;
        }

        public Builder setQr(Bitmap qrBitmap) {
            this.qrBitmap = qrBitmap;
            return this;
        }

        public Builder setMask(Bitmap maskBitmap) {
            this.maskBitmap = maskBitmap;
            return this;
        }

        public Builder setBg(Bitmap bgBitmap) {
            this.bgBitmap = bgBitmap;
            return this;
        }
    }
}

