/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.security;

import com.wizzardo.tools.io.IOTools;
import com.wizzardo.tools.misc.Unchecked;
import com.wizzardo.tools.security.MD5;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class AES {
    private Cipher ecipher;
    private Cipher dcipher;
    private SecretKey key;

    public static SecretKey generateKey() {
        KeyGenerator kg = null;
        try {
            kg = KeyGenerator.getInstance("AES");
            kg.init(128);
            return kg.generateKey();
        }
        catch (NoSuchAlgorithmException ex) {
            throw Unchecked.rethrow((Exception)ex);
        }
    }

    public static SecretKey generateKey(String key) {
        return AES.generateKey(key.getBytes());
    }

    public static SecretKey generateKeyAsMD5(String key) {
        return AES.generateKey(MD5.create().update(key).asBytes());
    }

    public static SecretKey generateKey(final byte[] key) {
        return new SecretKey(){
            private byte[] k;
            {
                if (key.length == 16) {
                    this.k = key;
                } else {
                    this.k = new byte[16];
                    System.arraycopy(key, 0, this.k, 0, key.length < 16 ? key.length : 16);
                }
            }

            @Override
            public String getAlgorithm() {
                return "AES";
            }

            @Override
            public String getFormat() {
                return "RAW";
            }

            @Override
            public byte[] getEncoded() {
                return this.k;
            }
        };
    }

    public AES() {
        try {
            KeyGenerator kg = KeyGenerator.getInstance("AES");
            kg.init(128);
            this.key = kg.generateKey();
            this.init();
        }
        catch (NoSuchAlgorithmException ex) {
            throw Unchecked.rethrow((Exception)ex);
        }
        catch (NoSuchPaddingException ex) {
            throw Unchecked.rethrow((Exception)ex);
        }
        catch (InvalidKeyException ex) {
            throw Unchecked.rethrow((Exception)ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw Unchecked.rethrow((Exception)ex);
        }
    }

    public AES(SecretKey key) {
        try {
            this.key = key;
            this.init();
        }
        catch (NoSuchAlgorithmException ex) {
            throw Unchecked.rethrow((Exception)ex);
        }
        catch (NoSuchPaddingException ex) {
            throw Unchecked.rethrow((Exception)ex);
        }
        catch (InvalidKeyException ex) {
            throw Unchecked.rethrow((Exception)ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw Unchecked.rethrow((Exception)ex);
        }
    }

    public AES(byte[] key) {
        this(AES.generateKey(key));
    }

    public AES(String key) {
        this(AES.generateKey(key.getBytes()));
    }

    public byte[] toTransfer() {
        return AES.toTransfer(this.key);
    }

    public static byte[] toTransfer(SecretKey key) {
        byte[] b = new byte[32];
        System.arraycopy(key.getEncoded(), 0, b, 0, 16);
        System.arraycopy(MD5.create().update(key.getEncoded()).asBytes(), 0, b, 16, 16);
        return b;
    }

    private void init() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] iv = this.key.getEncoded();
        IvParameterSpec paramSpec = new IvParameterSpec(iv);
        this.ecipher = Cipher.getInstance("AES/CFB8/NoPadding");
        this.dcipher = Cipher.getInstance("AES/CFB8/NoPadding");
        this.ecipher.init(1, (Key)this.key, paramSpec);
        this.dcipher.init(2, (Key)this.key, paramSpec);
    }

    public byte[] decrypt(byte[] b) {
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        ByteArrayOutputStream out = new ByteArrayOutputStream(b.length);
        this.decrypt(in, out);
        return out.toByteArray();
    }

    public byte[] encrypt(byte[] b) {
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        ByteArrayOutputStream out = new ByteArrayOutputStream(b.length);
        this.encrypt(in, out);
        return out.toByteArray();
    }

    public void decrypt(InputStream in, OutputStream out) {
        try {
            CipherInputStream inc = new CipherInputStream(in, this.dcipher);
            IOTools.copy((InputStream)inc, (OutputStream)out);
        }
        catch (IOException e) {
            throw Unchecked.rethrow((Exception)e);
        }
        finally {
            IOTools.close((Closeable)in);
            IOTools.close((Closeable)out);
        }
    }

    public void encrypt(InputStream in, OutputStream out) {
        try {
            out = new CipherOutputStream(out, this.ecipher);
            IOTools.copy((InputStream)in, (OutputStream)out);
            out.write(this.ecipher.doFinal());
        }
        catch (IOException e) {
            throw Unchecked.rethrow((Exception)e);
        }
        catch (BadPaddingException e) {
            throw Unchecked.rethrow((Exception)e);
        }
        catch (IllegalBlockSizeException e) {
            throw Unchecked.rethrow((Exception)e);
        }
        finally {
            IOTools.close((Closeable)in);
            IOTools.close((Closeable)out);
        }
    }
}

