/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.io;

import com.wizzardo.tools.io.BlockSizeType;
import com.wizzardo.tools.io.BytesTools;
import java.io.IOException;
import java.io.OutputStream;

public class SizedBlockOutputStream
extends OutputStream {
    protected OutputStream out;
    protected long blockLength = 0L;
    protected long written = 0L;
    protected BlockSizeType sizeType;

    public SizedBlockOutputStream(OutputStream out) {
        this(out, BlockSizeType.LONG);
    }

    public SizedBlockOutputStream(OutputStream out, BlockSizeType sizeType) {
        this.out = out;
        this.sizeType = sizeType;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int offset, int l) throws IOException {
        if ((long)l + this.written > this.blockLength) {
            throw new IllegalStateException("you are trying to write more bytes than was declared. " + ((long)l + this.written) + " > " + this.blockLength);
        }
        this.out.write(b, offset, l);
        this.written += (long)l;
    }

    public void setBlockLength(long l) throws IOException {
        if (this.written != this.blockLength) {
            throw new IllegalStateException("not all data was written. " + this.written + " != " + this.blockLength);
        }
        this.blockLength = l;
        this.written = 0L;
        BytesTools.toBytes(this.blockLength, this.out, this.sizeType.bytesCount);
    }

    public long left() {
        return this.blockLength - this.written;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }
}

