/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.io;

import com.wizzardo.tools.io.BlockSizeType;
import com.wizzardo.tools.io.BytesTools;
import com.wizzardo.tools.io.ProgressListener;
import java.io.IOException;
import java.io.InputStream;

public class SizedBlockInputStream
extends InputStream {
    protected InputStream in;
    protected long blockLength = 0L;
    protected long readed = 0L;
    protected ProgressListener listener;
    protected BlockSizeType sizeType;

    public SizedBlockInputStream(InputStream in) {
        this(in, BlockSizeType.LONG);
    }

    public SizedBlockInputStream(InputStream in, BlockSizeType sizeType) {
        this.in = in;
        this.sizeType = sizeType;
    }

    public boolean hasNext() throws IOException {
        int t;
        if (this.readed != this.blockLength) {
            throw new IllegalStateException("not all data has been read. " + this.readed + " != " + this.blockLength);
        }
        int r = 0;
        byte[] b = new byte[this.sizeType.bytesCount];
        for (t = 0; t != this.sizeType.bytesCount && (r = this.in.read(b, t, this.sizeType.bytesCount - t)) != -1; t += r) {
        }
        if (t == this.sizeType.bytesCount) {
            this.blockLength = BytesTools.toNumber(b, 0, this.sizeType.bytesCount);
            this.readed = 0L;
            return true;
        }
        return false;
    }

    public void setListener(ProgressListener listener) {
        this.listener = listener;
    }

    public long lenght() {
        return this.blockLength;
    }

    @Override
    public int read(byte[] b, int offset, int l) throws IOException {
        int r;
        if (this.blockLength == this.readed) {
            return -1;
        }
        if (this.blockLength - this.readed < (long)l) {
            l = (int)(this.blockLength - this.readed);
        }
        if ((r = this.in.read(b, offset, l)) == -1) {
            return -1;
        }
        this.readed += (long)r;
        if (this.listener != null) {
            this.listener.setProgress((int)(this.readed * 100L / this.blockLength));
        }
        return r;
    }

    @Override
    public int read() throws IOException {
        if (this.readed == this.blockLength) {
            return -1;
        }
        byte[] bytes = new byte[1];
        int r = this.read(bytes);
        if (r == 0) {
            return -1;
        }
        return bytes[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

