/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql.store;

import com.wix.mysql.config.DownloadConfig;
import com.wix.mysql.config.DownloadConfigBuilder;
import com.wix.mysql.config.MysqldConfig;
import com.wix.mysql.config.directories.TargetGeneratedFixedPath;
import com.wix.mysql.config.extract.NoopNaming;
import com.wix.mysql.config.extract.PathPrefixingNaming;
import com.wix.mysql.store.SafeExtractedArtifactStore;
import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.extract.DirectoryAndExecutableNaming;
import de.flapdoodle.embed.process.extract.ITempNaming;
import de.flapdoodle.embed.process.io.directories.FixedPath;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.store.Downloader;
import de.flapdoodle.embed.process.store.ExtractedArtifactStoreBuilder;
import de.flapdoodle.embed.process.store.IArtifactStore;
import de.flapdoodle.embed.process.store.IDownloader;
import java.io.File;
import java.util.UUID;

public class SafeExtractedArtifactStoreBuilder
extends ExtractedArtifactStoreBuilder {
    public SafeExtractedArtifactStoreBuilder defaults(MysqldConfig mysqldConfig, DownloadConfig downloadConfig) {
        String tempExtractDir = String.format("mysql-%s-%s", mysqldConfig.getVersion().getMajorVersion(), UUID.randomUUID());
        String combinedPath = new File(mysqldConfig.getTempDir(), tempExtractDir).getPath();
        FixedPath preExtractDir = new FixedPath(new File(downloadConfig.getCacheDir(), "extracted").getPath());
        this.executableNaming().setDefault((Object)new PathPrefixingNaming("bin/"));
        this.download().setDefault((Object)new DownloadConfigBuilder().defaults(downloadConfig).build());
        this.downloader().setDefault((Object)new Downloader());
        this.extractDir().setDefault((Object)preExtractDir);
        this.extractExecutableNaming().setDefault((Object)new NoopNaming());
        this.tempDir().setDefault((Object)new TargetGeneratedFixedPath(combinedPath));
        return this;
    }

    public IArtifactStore build() {
        DirectoryAndExecutableNaming extract = new DirectoryAndExecutableNaming((IDirectory)this.get(EXTRACT_DIR_FACTORY), (ITempNaming)this.get(EXTRACT_EXECUTABLE_NAMING));
        DirectoryAndExecutableNaming temp = new DirectoryAndExecutableNaming((IDirectory)this.tempDir().get(), (ITempNaming)this.executableNaming().get());
        return new SafeExtractedArtifactStore((IDownloadConfig)this.get(DOWNLOAD_CONFIG), (IDownloader)this.get(DOWNLOADER), extract, temp);
    }
}

