/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;

public class TimingOutProcessExecutor {
    private final String cmd;

    public TimingOutProcessExecutor(String cmd) {
        this.cmd = cmd;
    }

    public int waitFor(Process p, long timeoutNanos) throws InterruptedException, IOException {
        long startTime = System.nanoTime();
        long rem = timeoutNanos;
        while (true) {
            try {
                return p.exitValue();
            }
            catch (IllegalThreadStateException ex) {
                if (rem <= 0L) continue;
                Thread.sleep(Math.min(TimeUnit.NANOSECONDS.toMillis(rem) + 1L, 100L));
                if ((rem = timeoutNanos - (System.nanoTime() - startTime)) > 0L) continue;
                String collectedOutput = IOUtils.toString((InputStream)p.getInputStream()) + IOUtils.toString((InputStream)p.getErrorStream());
                p.destroy();
                throw new InterruptedException(String.format("Timeout of %s sec exceeded while waiting for '%s' to complete. Collected output: %s", TimeUnit.NANOSECONDS.toSeconds(timeoutNanos), this.cmd, collectedOutput));
            }
            break;
        }
    }
}

