/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql;

import com.wix.mysql.SqlScriptSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class Sources {
    public static SqlScriptSource fromString(String str) {
        return new StringSource(str);
    }

    public static SqlScriptSource fromFile(File str) {
        return new FileSource(str);
    }

    public static SqlScriptSource fromURL(URL str) {
        return new URLSource(str);
    }

    private static class URLSource
    implements SqlScriptSource {
        final URL url;

        URLSource(URL str) {
            this.url = str;
        }

        @Override
        public String read() throws IOException {
            InputStream in = this.url.openStream();
            try {
                String string = IOUtils.toString((InputStream)in);
                return string;
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    private static class FileSource
    implements SqlScriptSource {
        final File str;

        FileSource(File str) {
            this.str = str;
        }

        @Override
        public String read() throws IOException {
            return FileUtils.readFileToString((File)this.str);
        }
    }

    private static class StringSource
    implements SqlScriptSource {
        final String str;

        StringSource(String str) {
            this.str = str;
        }

        @Override
        public String read() {
            return this.str;
        }
    }
}

