/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql;

import com.wix.mysql.distribution.FileSet;
import com.wix.mysql.distribution.Version;
import de.flapdoodle.embed.process.config.store.IPackageResolver;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.BitSize;
import de.flapdoodle.embed.process.distribution.Distribution;

public class PackagePaths
implements IPackageResolver {
    public de.flapdoodle.embed.process.config.store.FileSet getFileSet(Distribution distribution) {
        return FileSet.emit(distribution.getPlatform(), (Version)distribution.getVersion());
    }

    public ArchiveType getArchiveType(Distribution distribution) {
        Version version = (Version)distribution.getVersion();
        return version.archiveType();
    }

    public String getPath(Distribution distribution) {
        String downloadPath = distribution.getVersion().asInDownloadPath();
        Version version = (Version)distribution.getVersion();
        BitSize bs = distribution.getBitsize();
        switch (distribution.getPlatform()) {
            case OS_X: {
                return String.format("%s-x86%s.tar.gz", downloadPath, bs == BitSize.B32 ? "" : "_64");
            }
            case Linux: {
                String gzOrXz = version.archiveType() == ArchiveType.TXZ ? "xz" : "gz";
                return String.format("%s-%s.tar.%s", downloadPath, bs == BitSize.B32 ? "i686" : "x86_64", gzOrXz);
            }
            case Windows: {
                return String.format("%s-win%s.zip", downloadPath, bs == BitSize.B32 ? "32" : "x64");
            }
        }
        throw new RuntimeException("Not implemented for: " + distribution.getPlatform());
    }
}

