/*
 * Decompiled with CFR 0.152.
 */
package com.wiris.plugin.storage;

import com.wiris.plugin.Base64;
import com.wiris.plugin.LibWIRIS;
import com.wiris.plugin.storage.FileStorageAndCache;
import com.wiris.plugin.storage.StorageAndCache;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class CompressedStorageAndCache
implements StorageAndCache {
    private StorageAndCache cache = null;

    public String codeDigest(String content) {
        try {
            return Base64.encodeBytes(content.getBytes("UTF-8"), 18);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public String decodeDigest(String digest) {
        try {
            return new String(Base64.decode(digest, 18), "UTF-8");
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private String getFileName(String digest) {
        try {
            return LibWIRIS.md5(digest.getBytes("US-ASCII"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public void init(HttpServletRequest request, Properties config) {
        if (config.getProperty("wiriscachedirectory") != null) {
            this.cache = new FileStorageAndCache();
            this.cache.init(request, config);
        }
    }

    public byte[] retreiveData(String digest) {
        if (this.cache == null) {
            return null;
        }
        String cacheDigest = this.getFileName(digest);
        return this.cache.retreiveData(cacheDigest);
    }

    public void storeData(String digest, byte[] stream) {
        if (this.cache != null) {
            String cacheDigest = this.getFileName(digest);
            this.cache.storeData(cacheDigest, stream);
        }
    }
}

