package com.wiris.plugin.dispatchers;

import java.io.IOException;
import java.io.PrintWriter;

import java.util.Iterator;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.wiris.plugin.LibWIRIS;

public abstract class EditorDispatcher {
    public static void dispatch(Properties config, HttpServletRequest request, 
                                HttpServletResponse response) throws IOException {
        response.setContentType("text/html; charset=utf-8");
        PrintWriter out = response.getWriter();

        out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
        out.print("<html><head><meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"/><script type=\"text/javascript\" src=\"../resources/editor.js\"></script><title>WIRIS Formula Editor</title><style type=\"text/css\">/*<!--*/html, body, #container { height: 100%; } body { margin: 0; } #links { text-align: right; margin-right: 20px; } #controls { float: left; } applet { width: 100%; }/*-->*/</style></head><body><div id=\"container\"><applet id=\"applet\" codebase=\"" + 
                  LibWIRIS.htmlentities(config.getProperty("wirisformulaeditorcodebase"), true) + "\" archive=\"" + 
                  LibWIRIS.htmlentities(config.getProperty("wirisformulaeditorarchive"), true) + "\" code=\"" + 
                  LibWIRIS.htmlentities(config.getProperty("wirisformulaeditorcode"), true) + 
                  "\"><param name=\"menuBar\" value=\"false\" />");

        String language = request.getParameter("lang");

        if (language != null) {
            config.setProperty("wirisformulaeditorlang", language);
        }

        Properties params = new Properties();
        params.setProperty("lang", "wirisformulaeditorlang");
        params.setProperty("identMathvariant", "wirisimageidentmathvariant");
        params.setProperty("numberMathvariant", "wirisimagenumbermathvariant");
        params.setProperty("fontIdent", "wirisimagefontident");
        params.setProperty("fontNumber", "wirisimagefontnumber");
        params.setProperty("version", "wirisimageserviceversion");

        Iterator keys = params.keySet().iterator();

        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = params.getProperty(key);
            String param = config.getProperty(value);

            if (param != null) {
                out.print("<param name=\"" + LibWIRIS.htmlentities(key, true) + "\" value=\"" + 
                          LibWIRIS.htmlentities(param, true) + "\" />");
            }
        }

        String fontRangesParam = config.getProperty("wirisimagefontranges");

        if (fontRangesParam != null) {
            String[] fontRanges = fontRangesParam.split(",");

            for (int i = 0; i < fontRanges.length; ++i) {
                String fontRangeName = fontRanges[i].trim();
                String fontRange = config.getProperty(fontRangeName);

                if (fontRange != null) {
                    out.print("<param name=\"font" + i + "\" value=\"" + LibWIRIS.htmlentities(fontRange, true) + "\" />");
                }
            }
        }

        out.print("<p>You need JAVA&reg; to use WIRIS tools.<br />FREE download from <a target=\"_blank\" href=\"http://www.java.com\">www.java.com</a></p></applet><div id=\"controls\"></div><div id=\"links\"><a href=\"http://www.wiris.com/portal/docs/editor-manual\" target=\"_blank\">Manual</a></div></div></body></html>");
        out.close();
    }
}
