package com.wiris.plugin.configuration;

import java.util.Enumeration;
import java.util.Properties;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

/**
 * This class overrides the configuration collecting the values from the 
 * servlet context.
 */
public class ParameterServletConfigurationUpdater implements ConfigurationUpdater2 {
    String PACKAGE_NAME = "com.wiris.plugin.";
    Properties prop = new Properties();

    public ParameterServletConfigurationUpdater() {
    }

    public void init(ServletContext conf) {
        Enumeration e = conf.getInitParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            // System.out.println(key);
            if (key.startsWith(PACKAGE_NAME)) {
                String value = conf.getInitParameter(key);
                prop.put(key.substring(PACKAGE_NAME.length()),value);
            }
        }
    }

    public void init() {
    }

    public void updateConfiguration(Properties configuration) {
        configuration.putAll(prop);
    }
}
