/*
 * Decompiled with CFR 0.152.
 */
package com.windowsazure.messaging;

import com.windowsazure.messaging.WindowsRegistration;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class WindowsTemplateRegistration
extends WindowsRegistration {
    private static final String WNS_TEMPLATE_REGISTRATION1 = "<?xml version=\"1.0\" encoding=\"utf-8\"?><entry xmlns=\"http://www.w3.org/2005/Atom\"><content type=\"application/xml\"><WindowsTemplateRegistrationDescription xmlns:i=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://schemas.microsoft.com/netservices/2010/10/servicebus/connect\">";
    private static final String WNS_TEMPLATE_REGISTRATION2 = "<ChannelUri>";
    private static final String WNS_TEMPLATE_REGISTRATION3 = "</ChannelUri><BodyTemplate><![CDATA[";
    private static final String WNS_TEMPLATE_REGISTRATION4 = "]]></BodyTemplate>";
    private static final String WNS_TEMPLATE_REGISTRATION5 = "</WindowsTemplateRegistrationDescription></content></entry>";
    private String bodyTemplate;
    private Map<String, String> headers = new HashMap<String, String>();

    public WindowsTemplateRegistration() {
    }

    public WindowsTemplateRegistration(URI channelUri, String bodyTemplate, Map<String, String> headers) {
        super(channelUri);
        this.bodyTemplate = bodyTemplate;
        this.headers = headers;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.bodyTemplate == null ? 0 : this.bodyTemplate.hashCode());
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WindowsTemplateRegistration other = (WindowsTemplateRegistration)obj;
        if (this.bodyTemplate == null ? other.bodyTemplate != null : !this.bodyTemplate.equals(other.bodyTemplate)) {
            return false;
        }
        return !(this.headers == null ? other.headers != null : !this.headers.equals(other.headers));
    }

    public WindowsTemplateRegistration(URI channelUri, String bodyTemplate) {
        super(channelUri);
        this.bodyTemplate = bodyTemplate;
    }

    public String getBodyTemplate() {
        return this.bodyTemplate;
    }

    public void setBodyTemplate(String bodyTemplate) {
        this.bodyTemplate = bodyTemplate;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Override
    public String getXml() {
        return WNS_TEMPLATE_REGISTRATION1 + this.getTagsXml() + WNS_TEMPLATE_REGISTRATION2 + this.channelUri.toString() + WNS_TEMPLATE_REGISTRATION3 + this.bodyTemplate + WNS_TEMPLATE_REGISTRATION4 + this.getHeadersXml() + WNS_TEMPLATE_REGISTRATION5;
    }

    private String getHeadersXml() {
        StringBuilder buf = new StringBuilder();
        if (!this.headers.isEmpty()) {
            buf.append("<WnsHeaders>");
            for (String key : this.headers.keySet()) {
                buf.append("<WnsHeader><Header>");
                buf.append(key).append("</Header><Value>");
                buf.append(this.headers.get(key)).append("</Value></WnsHeader>");
            }
        }
        buf.append("</WnsHeaders>");
        return buf.toString();
    }
}

