/*
 * Decompiled with CFR 0.152.
 */
package assertk.assertions;

import assertk.Assert;
import assertk.FailureKt;
import assertk.ValueAssert;
import assertk.assertions.AnyKt;
import assertk.assertions.CollectionKt;
import assertk.assertions.support.SupportKt;
import java.util.Collection;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u001a \u0010\u0000\u001a\u00020\u0001*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00022\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u001a\u001c\u0010\u0005\u001a\u00020\u0001*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0014\u0010\b\u001a\u00020\u0001*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002\u001a\u0014\u0010\t\u001a\u00020\u0001*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002\u001a\u0016\u0010\n\u001a\u00020\u0001*\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00030\u0002\u001a\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0002*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002\u00a8\u0006\u000b"}, d2={"hasSameSizeAs", "", "Lassertk/Assert;", "", "other", "hasSize", "size", "", "isEmpty", "isNotEmpty", "isNullOrEmpty", "assertk"})
@SourceDebugExtension(value={"SMAP\ncollection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 collection.kt\nassertk/assertions/CollectionKt\n+ 2 assert.kt\nassertk/Assert\n*L\n1#1,55:1\n50#2,8:56\n50#2,8:64\n50#2,8:72\n50#2,8:80\n*S KotlinDebug\n*F\n+ 1 collection.kt\nassertk/assertions/CollectionKt\n*L\n16#1:56,8\n25#1:64,8\n34#1:72,8\n49#1:80,8\n*E\n"})
public final class CollectionKt {
    @NotNull
    public static final Assert<Integer> size(@NotNull Assert<? extends Collection<?>> $this$size) {
        Intrinsics.checkNotNullParameter($this$size, (String)"<this>");
        return AnyKt.prop($this$size, "size", (Function1)size.1.INSTANCE);
    }

    public static final void isEmpty(@NotNull Assert<? extends Collection<?>> $this$isEmpty) {
        Intrinsics.checkNotNullParameter($this$isEmpty, (String)"<this>");
        Assert<? extends Collection<?>> this_$iv = $this$isEmpty;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Collection actual = (Collection)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (actual.isEmpty()) {
                    return;
                }
                SupportKt.expected$default($this$isEmpty, "to be empty but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isNotEmpty(@NotNull Assert<? extends Collection<?>> $this$isNotEmpty) {
        Intrinsics.checkNotNullParameter($this$isNotEmpty, (String)"<this>");
        Assert<? extends Collection<?>> this_$iv = $this$isNotEmpty;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Collection actual = (Collection)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (!actual.isEmpty()) {
                    return;
                }
                SupportKt.expected$default($this$isNotEmpty, "to not be empty", null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void isNullOrEmpty(@NotNull Assert<? extends Collection<?>> $this$isNullOrEmpty) {
        Intrinsics.checkNotNullParameter($this$isNullOrEmpty, (String)"<this>");
        Assert<? extends Collection<?>> this_$iv = $this$isNullOrEmpty;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Collection actual = (Collection)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                if (actual == null || actual.isEmpty()) {
                    return;
                }
                SupportKt.expected$default($this$isNullOrEmpty, "to be null or empty but was:" + SupportKt.show$default(actual, null, 2, null), null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }

    public static final void hasSize(@NotNull Assert<? extends Collection<?>> $this$hasSize, int size2) {
        Intrinsics.checkNotNullParameter($this$hasSize, (String)"<this>");
        AnyKt.isEqualTo(CollectionKt.size($this$hasSize), size2);
    }

    public static final void hasSameSizeAs(@NotNull Assert<? extends Collection<?>> $this$hasSameSizeAs, @NotNull Collection<?> other) {
        Intrinsics.checkNotNullParameter($this$hasSameSizeAs, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        Assert<? extends Collection<?>> this_$iv = $this$hasSameSizeAs;
        boolean $i$f$given = false;
        if (this_$iv instanceof ValueAssert) {
            try {
                Collection actual = (Collection)((ValueAssert)this_$iv).getValue();
                boolean bl = false;
                int actualSize = actual.size();
                int otherSize = other.size();
                if (actualSize == otherSize) {
                    return;
                }
                SupportKt.expected$default($this$hasSameSizeAs, "to have same size as:" + SupportKt.show$default(other, null, 2, null) + " (" + otherSize + ") but was size:(" + actualSize + ')', null, null, 6, null);
                throw new KotlinNothingValueException();
            }
            catch (Throwable e$iv) {
                FailureKt.notifyFailure(e$iv);
            }
        }
    }
}

