/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.utils;

import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONUtils {
    private static final String LOG_TAG = JSONUtils.class.getName();

    public static String[] getStringArray(JSONObject payload, String fieldName) {
        List<String> stringList = JSONUtils.getStringList(payload, fieldName);
        if (stringList == null) {
            return null;
        }
        return stringList.toArray(new String[stringList.size()]);
    }

    public static List<String> getStringList(JSONObject payload, String fieldName) {
        JSONArray array = payload.optJSONArray(fieldName);
        if (array == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(array.length());
        for (int i = 0; i < array.length(); ++i) {
            try {
                list.add(array.getString(i));
                continue;
            }
            catch (JSONException e) {
                MAPLog.i(LOG_TAG, fieldName + " has no mapping in json, returning null array");
                return null;
            }
        }
        return list;
    }
}

