/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.thread;

import android.os.Bundle;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.authorization.api.AuthorizationListener;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.shared.APIListener;
import com.amazon.identity.auth.device.thread.MAPCallbackFuture;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.Serializable;

public class AuthzCallbackFuture
extends MAPCallbackFuture
implements AuthorizationListener {
    private static final String LOG_TAG = AuthzCallbackFuture.class.getName();
    private Bundle mCancelResult;

    public AuthzCallbackFuture() {
        this(null);
    }

    public AuthzCallbackFuture(AuthorizationListener listener) {
        super(listener);
    }

    public AuthzCallbackFuture(final APIListener listener) {
        super(new AuthorizationListener(){

            public void onSuccess(Bundle response) {
                if (listener != null) {
                    listener.onSuccess(response);
                }
            }

            public void onError(AuthError e) {
                if (listener != null) {
                    listener.onError(e);
                }
            }

            public void onCancel(Bundle cause) {
                MAPLog.w(LOG_TAG, "onCancel called in for APIListener");
            }
        });
    }

    public void onCancel(Bundle cause) {
        this.mCancelResult = cause;
        this.mCancelResult.putSerializable(AuthzConstants.BUNDLE_KEY.FUTURE.val, (Serializable)((Object)AuthzConstants.FUTURE_TYPE.CANCEL));
        this.mLatch.countDown();
        this.mListener.onCancel(this.mCancelResult);
    }

    protected Bundle getResultHelper() {
        if (this.mCancelResult != null) {
            return this.mCancelResult;
        }
        return super.getResultHelper();
    }
}

