/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.content.Context;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.endpoint.AbstractPandaRequest;
import com.amazon.identity.auth.device.endpoint.PandaResponse;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.message.BasicNameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOauthTokenRequest<T extends PandaResponse>
extends AbstractPandaRequest<T> {
    protected static final String OAUTH_END_POINT = "/auth/o2/token";
    protected static final String GRANT_TYPE_PARAM = "grant_type";
    private static final String APP_CLIENT_ID_PARAM = "client_id";
    private final String appFamilyId;
    private final String clientId;

    public AbstractOauthTokenRequest(Context context, AppInfo appInfo) throws AuthError {
        super(context, appInfo);
        if (appInfo == null) {
            throw new AuthError("Appinfo can not be null to make an OAuthTokenRequest", AuthError.ERROR_TYPE.ERROR_UNKNOWN);
        }
        this.appFamilyId = appInfo.getAppFamilyId();
        this.clientId = appInfo.getClientId();
    }

    @Override
    protected String getEndPoint() {
        return OAUTH_END_POINT;
    }

    protected abstract String getGrantType();

    protected abstract List<BasicNameValuePair> getExtraOauthTokenRequestParameters();

    @Override
    protected List<BasicNameValuePair> getExtraParameters() {
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair(GRANT_TYPE_PARAM, this.getGrantType()));
        parameters.add(new BasicNameValuePair(APP_CLIENT_ID_PARAM, this.clientId));
        List<BasicNameValuePair> extraParameters = this.getExtraOauthTokenRequestParameters();
        if (extraParameters != null) {
            parameters.addAll(extraParameters);
        }
        return parameters;
    }

    @Override
    protected List<Header> getExtraHeaders() {
        return new ArrayList<Header>();
    }

    protected String getAppFamilyId() {
        return this.appFamilyId;
    }
}

