/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.api.authorization;

import android.os.Bundle;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;

public final class AuthCancellation {
    private final Cause cause;
    private final String description;

    AuthCancellation(Bundle bundle) {
        this(Cause.fromCode(bundle.getInt(AuthzConstants.BUNDLE_KEY.CAUSE_ID.val)), bundle.getString(AuthzConstants.BUNDLE_KEY.ON_CANCEL_DESCRIPTION.val));
    }

    public AuthCancellation(Cause cause, String description) {
        this.cause = cause;
        this.description = description;
    }

    public Cause getCause() {
        return this.cause;
    }

    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cause == null ? 0 : this.cause.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthCancellation other = (AuthCancellation)obj;
        if (this.cause != other.cause) {
            return false;
        }
        return !(this.description == null ? other.description != null : !this.description.equals(other.description));
    }

    public String toString() {
        return String.format("%s {cause='%s', description='%s'}", super.toString(), this.cause.toString(), this.description);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Cause {
        FAILED_AUTHENTICATION;


        static Cause fromCode(int code) {
            switch (code) {
                default: 
            }
            return FAILED_AUTHENTICATION;
        }
    }
}

