/*
 * Decompiled with CFR 0.152.
 */
package com.willblaschko.android.alexa.interfaces.speechrecognizer;

import android.util.Log;
import com.willblaschko.android.alexa.callbacks.AsyncCallback;
import com.willblaschko.android.alexa.interfaces.AvsAudioException;
import com.willblaschko.android.alexa.interfaces.AvsException;
import com.willblaschko.android.alexa.interfaces.AvsResponse;
import com.willblaschko.android.alexa.interfaces.speechrecognizer.SpeechSendEvent;
import com.willblaschko.android.alexa.requestbody.DataRequestBody;
import java.io.IOException;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;

public class SpeechSendAudio
extends SpeechSendEvent {
    private static final String TAG = "SpeechSendAudio";
    long start = 0L;
    DataRequestBody requestBody;

    public void sendAudio(String url, String accessToken, @NotNull DataRequestBody requestBody, AsyncCallback<AvsResponse, Exception> callback) throws IOException {
        this.requestBody = requestBody;
        if (callback != null) {
            callback.start();
        }
        Log.i((String)TAG, (String)"Starting SpeechSendAudio procedure");
        this.start = System.currentTimeMillis();
        try {
            this.prepareConnection(url, accessToken);
            AvsResponse response = this.completePost();
            if (response != null && response.isEmpty()) {
                if (callback != null) {
                    callback.failure(new AvsAudioException("Nothing came back"));
                }
                return;
            }
            if (callback != null) {
                if (response != null) {
                    callback.success(response);
                }
                callback.complete();
            }
            Log.i((String)TAG, (String)"Audio sent");
            Log.i((String)TAG, (String)("Audio sending process took: " + (System.currentTimeMillis() - this.start)));
        }
        catch (AvsException | IOException e) {
            this.onError(callback, e);
        }
    }

    public void cancelRequest() {
        this.cancelCall();
    }

    public void onError(AsyncCallback<AvsResponse, Exception> callback, Exception e) {
        if (callback != null) {
            callback.failure(e);
            callback.complete();
        }
    }

    @Override
    @NotNull
    protected RequestBody getRequestBody() {
        return this.requestBody;
    }
}

