/*
 * Decompiled with CFR 0.152.
 */
package com.willblaschko.android.alexa.data;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class Event {
    Header header;
    Payload payload;

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    public static String getSpeechRecognizerEvent() {
        Builder builder = new Builder();
        builder.setHeaderNamespace("SpeechRecognizer").setHeaderName("Recognize").setHeaderMessageId(Event.getUuid()).setHeaderDialogRequestId("dialogRequest-321").setPayloadFormat("AUDIO_L16_RATE_16000_CHANNELS_1").setPayloadProfile("CLOSE_TALK");
        return builder.toJson();
    }

    public static String getVolumeChangedEvent(long volume, boolean isMute) {
        Builder builder = new Builder();
        builder.setHeaderNamespace("Speaker").setHeaderName("VolumeChanged").setHeaderMessageId(Event.getUuid()).setPayloadVolume(volume).setPayloadMuted(isMute);
        return builder.toJson();
    }

    public static String getMuteEvent(boolean isMute) {
        Builder builder = new Builder();
        builder.setHeaderNamespace("Speaker").setHeaderName("VolumeChanged").setHeaderMessageId(Event.getUuid()).setPayloadMuted(isMute);
        return builder.toJson();
    }

    public static String getExpectSpeechTimedOutEvent() {
        Builder builder = new Builder();
        builder.setHeaderNamespace("SpeechRecognizer").setHeaderName("ExpectSpeechTimedOut").setHeaderMessageId(Event.getUuid());
        return builder.toJson();
    }

    public static String getSpeechNearlyFinishedEvent(String token, long offsetInMilliseconds) {
        Builder builder = new Builder();
        builder.setHeaderNamespace("SpeechSynthesizer").setHeaderName("PlaybackNearlyFinished").setHeaderMessageId(Event.getUuid()).setPayloadToken(token).setPlayloadOffsetInMilliseconds(offsetInMilliseconds);
        return builder.toJson();
    }

    public static String getPlaybackNearlyFinishedEvent(String token, long offsetInMilliseconds) {
        Builder builder = new Builder();
        builder.setHeaderNamespace("AudioPlayer").setHeaderName("PlaybackNearlyFinished").setHeaderMessageId(Event.getUuid()).setPayloadToken(token).setPlayloadOffsetInMilliseconds(offsetInMilliseconds);
        return builder.toJson();
    }

    public static String getSetAlertSucceededEvent(String token) {
        return Event.getAlertEvent(token, "SetAlertSucceeded");
    }

    public static String getSetAlertFailedEvent(String token) {
        return Event.getAlertEvent(token, "SetAlertFailed");
    }

    public static String getDeleteAlertSucceededEvent(String token) {
        return Event.getAlertEvent(token, "DeleteAlertSucceeded");
    }

    public static String getDeleteAlertFailedEvent(String token) {
        return Event.getAlertEvent(token, "DeleteAlertFailed");
    }

    public static String getAlertStartedEvent(String token) {
        return Event.getAlertEvent(token, "AlertStarted");
    }

    public static String getAlertStoppedEvent(String token) {
        return Event.getAlertEvent(token, "AlertStopped");
    }

    public static String getAlertEnteredForegroundEvent(String token) {
        return Event.getAlertEvent(token, "AlertEnteredForeground");
    }

    public static String getAlertEnteredBackgroundEvent(String token) {
        return Event.getAlertEvent(token, "AlertEnteredBackground");
    }

    private static String getAlertEvent(String token, String type) {
        Builder builder = new Builder();
        builder.setHeaderNamespace("Alerts").setHeaderName(type).setHeaderMessageId(Event.getUuid()).setPayloadToken(token);
        return builder.toJson();
    }

    public static String getSpeechStartedEvent(String token) {
        Builder builder = new Builder();
        builder.setHeaderNamespace("SpeechSynthesizer").setHeaderName("SpeechStarted").setHeaderMessageId(Event.getUuid()).setPayloadToken(token);
        return builder.toJson();
    }

    public static String getSpeechFinishedEvent(String token) {
        Builder builder = new Builder();
        builder.setHeaderNamespace("SpeechSynthesizer").setHeaderName("SpeechFinished").setHeaderMessageId(Event.getUuid()).setPayloadToken(token);
        return builder.toJson();
    }

    public static String getPlaybackStartedEvent(String token) {
        Builder builder = new Builder();
        builder.setHeaderNamespace("AudioPlayer").setHeaderName("PlaybackStarted").setHeaderMessageId(Event.getUuid()).setPayloadToken(token);
        return builder.toJson();
    }

    public static String getPlaybackFinishedEvent(String token) {
        Builder builder = new Builder();
        builder.setHeaderNamespace("AudioPlayer").setHeaderName("PlaybackFinished").setHeaderMessageId(Event.getUuid()).setPayloadToken(token);
        return builder.toJson();
    }

    public static String getSynchronizeStateEvent() {
        Builder builder = new Builder();
        builder.setHeaderNamespace("System").setHeaderName("SynchronizeState").setHeaderMessageId(Event.getUuid());
        return builder.toJson();
    }

    private static String getUuid() {
        String uuid = UUID.randomUUID().toString();
        return uuid;
    }

    public static class Builder {
        Event event = new Event();
        Payload payload = new Payload();
        Header header = new Header();
        List<Event> context = new ArrayList<Event>();

        public Builder() {
            this.event.setPayload(this.payload);
            this.event.setHeader(this.header);
        }

        public EventWrapper build() {
            EventWrapper wrapper = new EventWrapper();
            wrapper.event = this.event;
            if (!(this.context == null || this.context.isEmpty() || this.context.size() == 1 && this.context.get(0) == null)) {
                wrapper.context = this.context;
            }
            return wrapper;
        }

        public String toJson() {
            return this.build().toJson();
        }

        public Builder setContext(List<Event> context) {
            if (context == null) {
                return this;
            }
            this.context = context;
            return this;
        }

        public Builder setHeaderNamespace(String namespace) {
            this.header.namespace = namespace;
            return this;
        }

        public Builder setHeaderName(String name) {
            this.header.name = name;
            return this;
        }

        public Builder setHeaderMessageId(String messageId) {
            this.header.messageId = messageId;
            return this;
        }

        public Builder setHeaderDialogRequestId(String dialogRequestId) {
            this.header.dialogRequestId = dialogRequestId;
            return this;
        }

        public Builder setPayloadProfile(String profile) {
            this.payload.profile = profile;
            return this;
        }

        public Builder setPayloadFormat(String format) {
            this.payload.format = format;
            return this;
        }

        public Builder setPayloadMuted(boolean muted) {
            this.payload.muted = muted;
            return this;
        }

        public Builder setPayloadVolume(long volume) {
            this.payload.volume = volume;
            return this;
        }

        public Builder setPayloadToken(String token) {
            this.payload.token = token;
            return this;
        }

        public Builder setPlayloadOffsetInMilliseconds(long offsetInMilliseconds) {
            this.payload.offsetInMilliseconds = offsetInMilliseconds;
            return this;
        }
    }

    public static class EventWrapper {
        Event event;
        List<Event> context;

        public Event getEvent() {
            return this.event;
        }

        public List<Event> getContext() {
            return this.context;
        }

        public String toJson() {
            return new Gson().toJson((Object)this) + "\n";
        }
    }

    public static class Payload {
        String token;
        String profile;
        String format;
        boolean muted;
        long volume;
        long offsetInMilliseconds;

        public String getProfile() {
            return this.profile;
        }

        public String getFormat() {
            return this.format;
        }
    }

    public static class Header {
        String namespace;
        String name;
        String messageId;
        String dialogRequestId;

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public String getDialogRequestId() {
            return this.dialogRequestId;
        }

        public void setDialogRequestId(String dialogRequestId) {
            this.dialogRequestId = dialogRequestId;
        }
    }
}

