/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.content.Context;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.endpoint.AbstractJsonPandaRequest;
import com.amazon.identity.auth.device.endpoint.OneTimeCodeResponse;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.message.BasicNameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneTimeCodeRequest
extends AbstractJsonPandaRequest<OneTimeCodeResponse> {
    private static final String LOG_TAG = OneTimeCodeRequest.class.getName();
    private static final String ONE_TIME_CODE_ENDPOINT = "/auth/create/oneTimeCode";
    private static final String WORKFLOW_CLIENT_ID_PARAMETER = "workflowClientId";
    private static final String ACCESS_TOKEN_PARAMETER = "accessToken";
    private String workflowClientId;
    private String accessToken;

    public OneTimeCodeRequest(Context context, String workflowClientId, String accessToken, AppInfo appInfo) {
        super(context, appInfo);
        this.workflowClientId = workflowClientId;
        this.accessToken = accessToken;
    }

    @Override
    public String getEndPoint() {
        return ONE_TIME_CODE_ENDPOINT;
    }

    @Override
    protected List<BasicNameValuePair> getExtraParameters() {
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair(WORKFLOW_CLIENT_ID_PARAMETER, this.workflowClientId));
        parameters.add(new BasicNameValuePair(ACCESS_TOKEN_PARAMETER, this.accessToken));
        return parameters;
    }

    @Override
    protected OneTimeCodeResponse generateResponse(HttpResponse httpResponse) {
        return new OneTimeCodeResponse(httpResponse);
    }

    @Override
    protected void logRequest() {
        MAPLog.pii(LOG_TAG, "Executing create one time code request. workflowClientId=" + this.workflowClientId, "accessToken=" + this.accessToken);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessToken == null ? 0 : this.accessToken.hashCode());
        result = 31 * result + (this.workflowClientId == null ? 0 : this.workflowClientId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OneTimeCodeRequest other = (OneTimeCodeRequest)obj;
        if (this.accessToken == null && other.accessToken != null) {
            return false;
        }
        if (!this.accessToken.equals(other.accessToken)) {
            return false;
        }
        if (this.workflowClientId == null && other.workflowClientId != null) {
            return false;
        }
        return this.workflowClientId.equals(other.workflowClientId);
    }
}

