/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.authorization.EndpointDomainBuilder;
import com.amazon.identity.auth.device.authorization.Service;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.endpoint.PandaResponse;
import com.amazon.identity.auth.device.utils.DefaultLibraryInfo;
import com.amazon.identity.auth.device.utils.MAPUtils;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPandaRequest<T extends PandaResponse> {
    private static final String LOG_TAG = AbstractPandaRequest.class.getName();
    protected static final String DI_HW_NAME = "di.hw.name";
    protected static final String DI_HW_VERSION = "di.hw.version";
    protected static final String DI_OS_NAME = "di.os.name";
    protected static final String DI_OS_VERSION = "di.os.version";
    protected static final String DI_SDK_VERSION = "di.sdk.version";
    protected static final String APP_VERSION = "app_version";
    protected static final String APP_NAME = "app_name";
    protected static final String ANDROID_OS_NAME = "Android";
    protected static final int NUM_RETRY_ATTEMPTS = 2;
    private static final int MAX_NUM_POST_PARAMS = 10;
    protected static final String DEFAULT_TOP_LEVEL_DOMAIN = ".amazon.com";
    protected static final String API_PREFIX_DEVO = "api.integ";
    protected static final String API_PREFIX_PRE_PROD = "api.pre-prod";
    protected static final String API_PREFIX_PROD = "api";
    private static final String DEFAULT_USER_AGENT = "LWAAndroidSDK/3.0.0/Android/" + Build.VERSION.RELEASE + "/" + Build.MODEL;
    private HttpClient httpClient;
    protected HttpRequestBase httpRequest;
    private int socketTimeout = -1;
    protected final List<NameValuePair> postParameters;
    private String appName;
    private String appVersion;
    private String libVersion;
    private final List<Header> headers = new ArrayList<Header>();
    private Context context;
    private AppInfo appInfo;

    public AbstractPandaRequest(Context context, AppInfo appInfo) {
        this.context = context;
        this.appInfo = appInfo;
        this.postParameters = new ArrayList<NameValuePair>(10);
        this.appName = MAPUtils.getAppName(context);
        this.appVersion = MAPUtils.getVersion(context);
        this.libVersion = "3.0.0";
    }

    public final T submit() throws AuthError {
        this.initializeHttp();
        this.initializeUserAgent();
        this.initializePostParams();
        this.initializeHeaders();
        try {
            this.setEntity();
            for (Header header : this.headers) {
                this.httpRequest.addHeader(header);
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new AuthError(uee.getMessage(), uee, AuthError.ERROR_TYPE.ERROR_BAD_PARAM);
        }
        HttpResponse response = null;
        try {
            MAPLog.i(LOG_TAG, "Request url: " + this.httpRequest.getURI());
            for (int attempt = 0; attempt <= 2 && AbstractPandaRequest.hasReceived500(response = this.executeRequest()); ++attempt) {
                if (attempt != 2) {
                    response.getEntity().consumeContent();
                }
                MAPLog.w(LOG_TAG, "Received " + AbstractPandaRequest.getCode(response) + " error on request attempt " + (attempt + 1) + " of " + 3);
            }
        }
        catch (ClientProtocolException cpe) {
            MAPLog.e(LOG_TAG, "Received communication error when executing token request:" + cpe.toString());
            throw new AuthError("Received communication error when executing token request", cpe, AuthError.ERROR_TYPE.ERROR_COM);
        }
        catch (IOException ioe) {
            MAPLog.e(LOG_TAG, "Received IO error when executing token request:" + ioe.toString());
            throw new AuthError("Received communication error when executing token request", ioe, AuthError.ERROR_TYPE.ERROR_IO);
        }
        catch (IllegalStateException ise) {
            MAPLog.e(LOG_TAG, "Received IllegalStateException error when executing token request:" + ise.toString());
            throw new AuthError("Received communication error when executing token request", ise, AuthError.ERROR_TYPE.ERROR_COM);
        }
        finally {
            if (this.httpClient != null) {
                this.httpClient.getConnectionManager().closeIdleConnections(5L, TimeUnit.SECONDS);
            }
            if (this.httpRequest != null) {
                try {
                    this.consumeEntity();
                }
                catch (IOException e) {
                    MAPLog.e(LOG_TAG, "IOException consuming httppost entity content " + e.toString());
                }
            }
        }
        return this.generateResponse(response);
    }

    protected abstract String getEndPoint();

    protected abstract List<Header> getExtraHeaders();

    protected abstract List<BasicNameValuePair> getExtraParameters();

    protected abstract void logRequest();

    protected abstract T generateResponse(HttpResponse var1);

    protected HttpRequestBase initializeRequest(String uri) {
        return new HttpPost(uri);
    }

    protected void consumeEntity() throws IOException {
        ((HttpPost)this.httpRequest).getEntity().consumeContent();
    }

    protected void setEntity() throws UnsupportedEncodingException, AuthError {
        UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(this.getPostParameters());
        ((HttpPost)this.httpRequest).setEntity((HttpEntity)urlEncodedFormEntity);
    }

    protected boolean isSandboxEnabled() {
        return false;
    }

    List<NameValuePair> getPostParameters() {
        for (NameValuePair parameter : this.postParameters) {
            if (parameter != null) {
                MAPLog.pii(LOG_TAG, "Parameter Added to request", "name=" + parameter.getName() + " val=" + parameter.getValue());
                continue;
            }
            MAPLog.e(LOG_TAG, "Parameter Added to request was NULL");
        }
        return this.postParameters;
    }

    List<Header> getHeaders() {
        return this.headers;
    }

    HttpResponse executeRequest() throws ClientProtocolException, IOException {
        if (this.socketTimeout != -1) {
            HttpParams params = this.httpRequest.getParams();
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)this.socketTimeout);
            this.httpRequest.setParams(params);
        }
        this.logRequestInfo();
        return this.httpClient.execute((HttpUriRequest)this.httpRequest);
    }

    String getRequestUrl() throws AuthError {
        String endPoint = this.getEndPoint();
        try {
            String domain = new EndpointDomainBuilder(this.context, this.appInfo).forService(Service.PANDA).forSandbox(this.isSandboxEnabled()).getDomain();
            return new URL(domain + endPoint).toString();
        }
        catch (MalformedURLException e) {
            throw new AuthError("MalformedURLException", e, AuthError.ERROR_TYPE.ERROR_BAD_PARAM);
        }
    }

    private void initializeHttp() throws AuthError {
        if (this.httpClient == null) {
            this.httpClient = DefaultLibraryInfo.isDevo() ? new UnsafeSslHttpClient() : new DefaultHttpClient();
            this.httpRequest = this.initializeRequest(this.getRequestUrl());
        }
    }

    private void initializeUserAgent() {
        this.httpClient.getParams().setParameter("http.useragent", (Object)DEFAULT_USER_AGENT);
    }

    private void logRequestInfo() {
        String userAgent = (String)this.httpClient.getParams().getParameter("http.useragent");
        MAPLog.pii(LOG_TAG, "Logging Request info.", "UserAgent = " + userAgent);
        Header[] headers = this.httpRequest.getAllHeaders();
        if (headers != null) {
            MAPLog.i(LOG_TAG, "Number of Headers : " + headers.length);
            for (Header header : headers) {
                MAPLog.pii(LOG_TAG, "Header used for request: name=" + header.getName(), "val=" + header.getValue());
            }
        } else {
            MAPLog.i(LOG_TAG, "No Headers");
        }
        this.logRequest();
    }

    private static boolean hasReceived500(HttpResponse response) {
        int code = response.getStatusLine().getStatusCode();
        return code >= 500 && code < 600;
    }

    private static int getCode(HttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }

    private void initializePostParams() throws AuthError {
        this.addExtraParameters();
        this.addAppInfoParameters();
        this.addDeviceParams();
    }

    private void addDeviceParams() throws AuthError {
        if (!TextUtils.isEmpty((CharSequence)Build.MANUFACTURER) && !Build.MANUFACTURER.equals("unknown")) {
            this.postParameters.add((NameValuePair)new BasicNameValuePair(DI_HW_NAME, Build.MANUFACTURER));
        }
        if (!TextUtils.isEmpty((CharSequence)Build.MODEL) && !Build.MODEL.equals("unknown")) {
            this.postParameters.add((NameValuePair)new BasicNameValuePair(DI_HW_VERSION, Build.MODEL));
        }
        this.postParameters.add((NameValuePair)new BasicNameValuePair(DI_OS_NAME, ANDROID_OS_NAME));
        if (!TextUtils.isEmpty((CharSequence)Build.VERSION.RELEASE) && !Build.VERSION.RELEASE.equals("unknown")) {
            this.postParameters.add((NameValuePair)new BasicNameValuePair(DI_OS_VERSION, Build.VERSION.RELEASE));
        }
        this.postParameters.add((NameValuePair)new BasicNameValuePair(DI_SDK_VERSION, this.libVersion));
    }

    private void addAppInfoParameters() throws AuthError {
        this.postParameters.add((NameValuePair)new BasicNameValuePair(APP_NAME, this.appName));
        if (this.appVersion != null) {
            this.postParameters.add((NameValuePair)new BasicNameValuePair(APP_VERSION, this.appVersion));
        }
    }

    private void addExtraParameters() {
        List<BasicNameValuePair> extraParameters = this.getExtraParameters();
        if (extraParameters != null) {
            this.postParameters.addAll(extraParameters);
        }
    }

    private void initializeHeaders() throws AuthError {
        this.addDefaultHeaders();
        this.addExtraHeaders();
    }

    private void addDefaultHeaders() {
        this.headers.add((Header)new BasicHeader("Accept-Encoding", "gzip, deflate"));
        this.headers.add((Header)new BasicHeader("Accept-Language", "en-us,en;q=0.5"));
        this.headers.add((Header)new BasicHeader("Accept", "application/xml,application/xhtml+xml,text/html,application/json;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5"));
        this.headers.add((Header)new BasicHeader("Accept-Charset", "utf-8, iso-8859-1, utf-16, *;q=0.7"));
    }

    private void addExtraHeaders() {
        List<Header> extraHeaders = this.getExtraHeaders();
        if (extraHeaders != null) {
            this.headers.addAll(extraHeaders);
        }
    }

    private class UnsafeSslHttpClient
    extends DefaultHttpClient {
        private static final String BKS = "BKS";
        private static final String HTTP = "http";
        private static final String HTTPS = "https";

        private SSLSocketFactory newSslSocketFactory() {
            try {
                KeyStore trusted = KeyStore.getInstance(BKS);
                MySSLSocketFactory factory = new MySSLSocketFactory(trusted);
                factory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                return factory;
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }

        protected ClientConnectionManager createClientConnectionManager() {
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme(HTTP, (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
            registry.register(new Scheme(HTTPS, (SocketFactory)this.newSslSocketFactory(), 443));
            return new SingleClientConnManager(this.getParams(), registry);
        }

        private class MySSLSocketFactory
        extends SSLSocketFactory {
            SSLContext sslContext;

            public MySSLSocketFactory(KeyStore truststore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
                super(truststore);
                this.sslContext = SSLContext.getInstance("TLS");
                X509TrustManager tm = new X509TrustManager(){

                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
                this.sslContext.init(null, new TrustManager[]{tm}, null);
            }

            public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
                return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
            }

            public Socket createSocket() throws IOException {
                return this.sslContext.getSocketFactory().createSocket();
            }
        }
    }
}

