/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.authorization;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.appid.ThirdPartyAppIdentifier;
import com.amazon.identity.auth.device.authorization.AuthorizationHelper;
import com.amazon.identity.auth.device.authorization.AuthorizationResponseParser;
import com.amazon.identity.auth.device.authorization.CodeChallengeWorkflow;
import com.amazon.identity.auth.device.authorization.InternalAuthManager;
import com.amazon.identity.auth.device.authorization.api.AuthorizationListener;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.endpoint.TokenVendor;
import com.amazon.identity.auth.device.utils.LWAConstants;
import com.amazon.identity.auth.map.device.utils.MAPLog;

public final class AuthorizationResponseProcessor {
    private static final String LOG_TAG = AuthorizationResponseProcessor.class.getName();
    private static final String CODE_KEY = "code";

    public static void handleResponse(Context context, Uri uri, String[] requestedScopes, boolean returnAccessToken, final AuthorizationListener listener) {
        block4: {
            AuthorizationResponseParser parser = new AuthorizationResponseParser();
            MAPLog.pii(LOG_TAG, "Received response from WebBroswer for OAuth2 flow", "response=" + uri.toString());
            try {
                Bundle result = parser.extractResultsBundle(uri, requestedScopes);
                if (result.containsKey(AuthzConstants.BUNDLE_KEY.CAUSE_ID.val)) {
                    listener.onCancel(result);
                    return;
                }
                boolean shouldGetAuthCode = result.getBoolean(AuthzConstants.BUNDLE_KEY.GET_AUTH_CODE.val, false);
                if (shouldGetAuthCode) {
                    String clientId = InternalAuthManager.getInstance(context).getClientId();
                    String redirectURI = InternalAuthManager.getInstance(context).getRedirectURI(context);
                    AuthorizationHelper.sendAuthorizationCodeAsResponse(result.getString(CODE_KEY), clientId, redirectURI, listener);
                    return;
                }
                Bundle options = new Bundle();
                options.putBoolean(LWAConstants.AUTHORIZE_BUNDLE_KEY.RETURN_ACCESS_TOKEN.val, returnAccessToken);
                AuthorizationHelper helper = new AuthorizationHelper();
                String codeVerifier = CodeChallengeWorkflow.getInstance().getCodeVerifier();
                helper.doCodeForTokenExchange(context, context.getPackageName(), codeVerifier, result, false, null, new TokenVendor(), new ThirdPartyAppIdentifier(), options, new AuthorizationListener(){

                    public void onSuccess(Bundle response) {
                        MAPLog.w(LOG_TAG, "Code for Token Exchange success");
                        if (listener != null) {
                            listener.onSuccess(response);
                        }
                    }

                    public void onError(AuthError e) {
                        MAPLog.w(LOG_TAG, "Code for Token Exchange Error. " + e.getMessage());
                        if (listener != null) {
                            listener.onError(e);
                        }
                    }

                    public void onCancel(Bundle cause) {
                        MAPLog.w(LOG_TAG, "Code for Token Exchange Cancel");
                        if (listener != null) {
                            listener.onCancel(cause);
                        }
                    }
                });
            }
            catch (AuthError e) {
                if (listener == null) break block4;
                listener.onError(e);
            }
        }
    }
}

