/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.api.authorization;

import com.amazon.identity.auth.device.api.authorization.Scope;
import org.json.JSONObject;

public final class ScopeFactory {
    private ScopeFactory() {
    }

    public static Scope scopeNamed(String name) {
        return new GenericScope(name);
    }

    public static Scope scopeNamed(String name, JSONObject scopeData) {
        return new GenericScope(name, scopeData);
    }

    static final class GenericScope
    implements Scope {
        private final String name;
        private final JSONObject scopeData;

        GenericScope(String name) {
            this(name, null);
        }

        GenericScope(String name, JSONObject scopeData) {
            if (name == null) {
                throw new IllegalArgumentException("Scope must have a name");
            }
            this.name = name;
            this.scopeData = scopeData;
        }

        public String getName() {
            return this.name;
        }

        public JSONObject getScopeData() {
            return this.scopeData;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.scopeData == null ? 0 : this.scopeData.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GenericScope other = (GenericScope)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.scopeData == null ? other.scopeData != null : !this.scopeData.equals(other.scopeData));
        }
    }
}

