/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.api.authorization;

import android.content.Context;
import android.os.Bundle;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.StoredPreferences;
import com.amazon.identity.auth.device.api.Listener;
import com.amazon.identity.auth.device.api.authorization.AuthCancellation;
import com.amazon.identity.auth.device.api.authorization.AuthorizeListener;
import com.amazon.identity.auth.device.api.authorization.AuthorizeRequest;
import com.amazon.identity.auth.device.api.authorization.AuthorizeResult;
import com.amazon.identity.auth.device.api.authorization.Region;
import com.amazon.identity.auth.device.api.authorization.Scope;
import com.amazon.identity.auth.device.authorization.InternalAuthManager;
import com.amazon.identity.auth.device.authorization.api.AuthorizationListener;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.shared.APIListener;
import com.amazon.identity.auth.device.utils.LWAConstants;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AuthorizationManager {
    private static final String LOG_TAG = AuthorizationManager.class.getName();
    private static Boolean sandboxMode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSandboxMode(Context context, boolean useSandbox) {
        boolean currentSandboxMode = AuthorizationManager.isSandboxMode(context);
        MAPLog.i(LOG_TAG, "Changing sandbox mode from " + currentSandboxMode + " to " + useSandbox);
        if (currentSandboxMode != useSandbox) {
            final CountDownLatch latch = new CountDownLatch(1);
            AuthorizationManager.signOut(context, new Listener<Void, AuthError>(){

                @Override
                public void onSuccess(Void result) {
                    latch.countDown();
                }

                @Override
                public void onError(AuthError e) {
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                MAPLog.e(LOG_TAG, "Interrupted waiting to sign out. Local auth state may be invalid", e);
            }
            finally {
                StoredPreferences.setSandboxMode(context, useSandbox);
            }
        }
        sandboxMode = useSandbox;
        MAPLog.i(LOG_TAG, "Sandbox mode changed to: " + useSandbox);
    }

    public static boolean isSandboxMode(Context context) {
        if (sandboxMode == null) {
            sandboxMode = StoredPreferences.isSandboxMode(context);
        }
        return sandboxMode;
    }

    public static void setRegion(Context context, Region region) {
        InternalAuthManager.getInstance(context).setRegion(context, region);
    }

    public static Region getRegion(Context context) {
        return InternalAuthManager.getInstance(context).getRegion(context);
    }

    public static void authorize(final AuthorizeRequest request) {
        final Context context = request.getContext();
        MAPLog.i(LOG_TAG, context.getPackageName() + " calling authorize");
        List<Scope> scopeList = request.getScopes();
        int numberOfScopes = scopeList.size();
        String[] scopes = new String[numberOfScopes];
        JSONObject allScopeData = new JSONObject();
        for (int index = 0; index < numberOfScopes; ++index) {
            String scopeName;
            Scope scope = scopeList.get(index);
            scopes[index] = scopeName = scope.getName();
            JSONObject scopeData = scope.getScopeData();
            if (scopeData == null) continue;
            try {
                allScopeData.put(scopeName, (Object)scope.getScopeData());
                continue;
            }
            catch (JSONException e) {
                MAPLog.pii(LOG_TAG, "Unable to serialize scope data for scope \"" + scopeName + "\"", scope.getScopeData().toString(), e);
            }
        }
        Bundle options = new Bundle();
        if (allScopeData.length() > 0) {
            options.putString(AuthzConstants.BUNDLE_KEY.SCOPE_DATA.val, allScopeData.toString());
        }
        if (request.getGrantType() == AuthorizeRequest.GrantType.AUTHORIZATION_CODE) {
            options.putBoolean(AuthzConstants.BUNDLE_KEY.GET_AUTH_CODE.val, true);
        }
        if (request.getCodeChallenge() != null) {
            options.putString(AuthzConstants.BUNDLE_KEY.CODE_CHALLENGE.val, request.getCodeChallenge());
        }
        if (request.getCodeChallengeMethod() != null) {
            options.putString(AuthzConstants.BUNDLE_KEY.CODE_CHALLENGE_METHOD.val, request.getCodeChallengeMethod());
        }
        options.putBoolean(LWAConstants.AUTHORIZE_BUNDLE_KEY.RETURN_ACCESS_TOKEN.val, true);
        InternalAuthManager.getInstance(context).authorize(request, context, scopes, options, new AuthorizationListener(){

            public void onSuccess(Bundle response) {
                AuthorizeListener.onAuthorizationSuccess(context, response, request, request.shouldReturnUserData());
            }

            public void onError(AuthError ae) {
                request.onError(ae);
            }

            public void onCancel(Bundle cause) {
                request.onCancel(new AuthCancellation(cause));
            }
        });
    }

    public static void getToken(Context context, Scope[] scopes, final Listener<AuthorizeResult, AuthError> listener) {
        MAPLog.i(LOG_TAG, context.getPackageName() + " calling getToken");
        String[] stringScopes = new String[scopes.length];
        for (int index = 0; index < scopes.length; ++index) {
            stringScopes[index] = scopes[index].getName();
        }
        InternalAuthManager.getInstance(context).getToken(context, stringScopes, new APIListener(){

            public void onSuccess(Bundle response) {
                listener.onSuccess(new AuthorizeResult(response));
            }

            public void onError(AuthError e) {
                listener.onError(e);
            }
        });
    }

    public static void signOut(Context context, final Listener<Void, AuthError> listener) {
        MAPLog.i(LOG_TAG, context.getPackageName() + " calling signOut");
        InternalAuthManager.getInstance(context).clearAuthorizationState(context, new APIListener(){

            public void onSuccess(Bundle response) {
                listener.onSuccess(null);
            }

            public void onError(AuthError e) {
                listener.onError(e);
            }
        });
    }
}

