/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device;

import android.content.Context;
import android.net.Uri;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.interactive.InteractiveRequest;
import com.amazon.identity.auth.device.interactive.InteractiveRequestRecord;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRequest {
    protected final InteractiveRequest<?, ?, ?, ?> originalRequest;
    protected final String requestId;
    private int attemptCount;

    public AbstractRequest(InteractiveRequest<?, ?, ?, ?> originalRequest) {
        this.originalRequest = originalRequest;
        this.requestId = UUID.randomUUID().toString();
        this.attemptCount = 0;
    }

    public InteractiveRequest<?, ?, ?, ?> getOriginalRequest() {
        return this.originalRequest;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void incrementAttemptCount() {
        ++this.attemptCount;
    }

    public boolean canAttempt() {
        return this.attemptCount < this.getMaxAttemptCount();
    }

    public int getMaxAttemptCount() {
        return 1;
    }

    public void onStart() {
        if (this.originalRequest != null) {
            this.originalRequest.getRequestContext().onStartRequest(this.getInteractiveRequestRecord());
        }
    }

    public InteractiveRequestRecord getInteractiveRequestRecord() {
        return new InteractiveRequestRecord(this.requestId, this.originalRequest.getRequestExtras());
    }

    public abstract String getUrl(Context var1) throws AuthError;

    public abstract boolean handleResponse(Uri var1, Context var2);
}

