/*
 * Decompiled with CFR 0.152.
 */
package com.willblaschko.android.alexa.connection;

import android.os.Build;
import android.util.Log;
import com.willblaschko.android.alexa.connection.Tls12SocketFactory;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.CipherSuite;
import okhttp3.ConnectionSpec;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.TlsVersion;

public class ClientUtil {
    private static OkHttpClient mClient;

    public static OkHttpClient getTLS12OkHttpClient() {
        if (mClient == null) {
            OkHttpClient.Builder client = new OkHttpClient.Builder();
            if (Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT < 22) {
                try {
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init((KeyStore)null);
                    Object[] trustManagers = trustManagerFactory.getTrustManagers();
                    if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                        throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
                    }
                    X509TrustManager trustManager = (X509TrustManager)trustManagers[0];
                    SSLContext sc = SSLContext.getInstance("TLSv1.2");
                    sc.init(null, null, null);
                    String[] enabled = sc.getSocketFactory().getDefaultCipherSuites();
                    String[] supported = sc.getSocketFactory().getSupportedCipherSuites();
                    client.sslSocketFactory((SSLSocketFactory)new Tls12SocketFactory(sc.getSocketFactory()), trustManager);
                    ConnectionSpec cs = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2}).cipherSuites(new CipherSuite[]{CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384}).build();
                    ArrayList<ConnectionSpec> specs = new ArrayList<ConnectionSpec>();
                    specs.add(cs);
                    client.connectionSpecs(specs);
                }
                catch (Exception exc) {
                    Log.e((String)"OkHttpTLSCompat", (String)"Error while setting TLS 1.2", (Throwable)exc);
                }
            }
            client.addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Request request = chain.request().newBuilder().addHeader("Connection", "close").build();
                    return chain.proceed(request);
                }
            });
            mClient = client.build();
        }
        return mClient;
    }
}

