/*
 * Decompiled with CFR 0.152.
 */
package com.willblaschko.android.alexa;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.authorization.api.AmazonAuthorizationManager;
import com.google.gson.Gson;
import com.willblaschko.android.alexa.connection.ClientUtil;
import com.willblaschko.android.alexa.utility.Util;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TokenManager {
    private static final String TAG = "TokenManager";
    private static String REFRESH_TOKEN;
    private static String ACCESS_TOKEN;
    private static final String ARG_GRANT_TYPE = "grant_type";
    private static final String ARG_CODE = "code";
    private static final String ARG_REDIRECT_URI = "redirect_uri";
    private static final String ARG_CLIENT_ID = "client_id";
    private static final String ARG_CODE_VERIFIER = "code_verifier";
    private static final String ARG_REFRESH_TOKEN = "refresh_token";
    public static final String PREF_ACCESS_TOKEN = "access_token";
    public static final String PREF_REFRESH_TOKEN = "refresh_token";
    public static final String PREF_TOKEN_EXPIRES = "token_expires";

    public static void getAccessToken(final Context context, @NotNull String authCode, @NotNull String codeVerifier, AmazonAuthorizationManager authorizationManager, final @Nullable TokenResponseCallback callback) {
        String url = "https://api.amazon.com/auth/O2/token";
        FormBody.Builder builder = new FormBody.Builder().add(ARG_GRANT_TYPE, "authorization_code").add(ARG_CODE, authCode);
        try {
            builder.add(ARG_REDIRECT_URI, authorizationManager.getRedirectUri());
            builder.add(ARG_CLIENT_ID, authorizationManager.getClientId());
        }
        catch (AuthError authError) {
            authError.printStackTrace();
        }
        builder.add(ARG_CODE_VERIFIER, codeVerifier);
        OkHttpClient client = ClientUtil.getTLS12OkHttpClient();
        Request request = new Request.Builder().url(url).post((RequestBody)builder.build()).build();
        final Handler handler = new Handler(Looper.getMainLooper());
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, final IOException e) {
                e.printStackTrace();
                if (callback != null) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    });
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                String s = response.body().string();
                final TokenResponse tokenResponse = (TokenResponse)new Gson().fromJson(s, TokenResponse.class);
                TokenManager.saveTokens(context, tokenResponse);
                if (callback != null) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(tokenResponse);
                        }
                    });
                }
            }
        });
    }

    public static void getAccessToken(@NotNull AmazonAuthorizationManager authorizationManager, @NotNull Context context, @NotNull TokenCallback callback) {
        SharedPreferences preferences = Util.getPreferences(context.getApplicationContext());
        if (preferences.contains(PREF_ACCESS_TOKEN)) {
            if (preferences.getLong(PREF_TOKEN_EXPIRES, 0L) > System.currentTimeMillis()) {
                callback.onSuccess(preferences.getString(PREF_ACCESS_TOKEN, null));
                return;
            }
            if (preferences.contains("refresh_token")) {
                TokenManager.getRefreshToken(authorizationManager, context, callback, preferences.getString("refresh_token", ""));
                return;
            }
        }
        callback.onFailure(new IllegalStateException("User is not logged in and no refresh token found."));
    }

    private static void getRefreshToken(@NotNull AmazonAuthorizationManager authorizationManager, final @NotNull Context context, final @NotNull TokenCallback callback, String refreshToken) {
        String url = "https://api.amazon.com/auth/O2/token";
        FormBody.Builder builder = new FormBody.Builder().add(ARG_GRANT_TYPE, "refresh_token").add("refresh_token", refreshToken);
        try {
            builder.add(ARG_CLIENT_ID, authorizationManager.getClientId());
        }
        catch (AuthError authError) {
            authError.printStackTrace();
            callback.onFailure(authError);
        }
        OkHttpClient client = ClientUtil.getTLS12OkHttpClient();
        Request request = new Request.Builder().url(url).post((RequestBody)builder.build()).build();
        final Handler handler = new Handler(Looper.getMainLooper());
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, final IOException e) {
                e.printStackTrace();
                if (callback != null) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onFailure(e);
                        }
                    });
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                String s = response.body().string();
                final TokenResponse tokenResponse = (TokenResponse)new Gson().fromJson(s, TokenResponse.class);
                TokenManager.saveTokens(context, tokenResponse);
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onSuccess(tokenResponse.access_token);
                    }
                });
            }
        });
    }

    private static void saveTokens(Context context, TokenResponse tokenResponse) {
        REFRESH_TOKEN = tokenResponse.refresh_token;
        ACCESS_TOKEN = tokenResponse.access_token;
        SharedPreferences.Editor preferences = Util.getPreferences(context.getApplicationContext()).edit();
        preferences.putString(PREF_ACCESS_TOKEN, ACCESS_TOKEN);
        preferences.putString("refresh_token", REFRESH_TOKEN);
        preferences.putLong(PREF_TOKEN_EXPIRES, System.currentTimeMillis() + tokenResponse.expires_in * 1000L);
        preferences.commit();
    }

    public static interface TokenCallback {
        public void onSuccess(String var1);

        public void onFailure(Throwable var1);
    }

    public static class TokenResponse {
        public String access_token;
        public String refresh_token;
        public String token_type;
        public long expires_in;
    }

    public static interface TokenResponseCallback {
        public void onSuccess(TokenResponse var1);

        public void onFailure(Exception var1);
    }
}

