/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.datastore;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.amazon.identity.auth.device.dataobject.AbstractDataObject;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataSource<K extends AbstractDataObject> {
    private static final String LOG_TAG = AbstractDataSource.class.getName();
    public static final int INSERT_FAILED = -1;
    private static final int UPDATE_SUCCEEDED = 1;
    private static final int DELETE_SUCCEEDED = 1;
    protected SQLiteDatabase database;

    public AbstractDataSource(SQLiteDatabase database) {
        if (database == null) {
            throw new IllegalArgumentException("database can't be null!");
        }
        this.database = database;
    }

    public K findByRowId(long rowid) {
        return this.findOneRow(new String[]{"rowid"}, new String[]{"" + rowid});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K findOneRow(String[] selectionFields, String[] selectionValues) {
        Cursor cursor = null;
        K to_return = null;
        try {
            String whereClause = AbstractDataSource.getWhereClause(selectionFields, selectionValues);
            cursor = this.database.query(this.getTableName(), this.getAllColumns(), whereClause, null, null, null, null);
            if (cursor != null) {
                cursor.moveToFirst();
                to_return = this.cursorToObject(cursor);
            }
        }
        catch (IllegalArgumentException e) {
            MAPLog.e(this.getLogTag(), "" + e.getMessage(), e);
            to_return = null;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return to_return;
    }

    protected K findOneRowBySingleColumn(String colName, String colValue) {
        return this.findOneRow(new String[]{colName}, new String[]{colValue});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<K> findAllRows(String[] selectionFields, String[] selectionValues) {
        Cursor cursor = null;
        ArrayList<K> to_return = new ArrayList<K>();
        try {
            String whereClause = AbstractDataSource.getWhereClause(selectionFields, selectionValues);
            cursor = this.database.query(this.getTableName(), this.getAllColumns(), whereClause, null, null, null, null);
            if (cursor != null) {
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    K temp = this.cursorToObject(cursor);
                    if (temp == null) {
                        throw new IllegalArgumentException("cursor contains invalid object!");
                    }
                    to_return.add(temp);
                    cursor.moveToNext();
                }
            }
        }
        catch (IllegalArgumentException e) {
            MAPLog.e(this.getLogTag(), "" + e.getMessage(), e);
            to_return.clear();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return to_return;
    }

    protected List<K> findAllRowsBySingleColumn(String colName, String colValue) {
        return this.findAllRows(new String[]{colName}, new String[]{colValue});
    }

    public List<K> findAllRows() {
        return this.findAllRows(null, null);
    }

    public long insertRow(K object) {
        if (object == null) {
            return -1L;
        }
        MAPLog.pii(LOG_TAG, "Insert Row table=" + this.getTableName(), "vals=" + ((AbstractDataObject)object).getValuesForInsert());
        long rowId = this.database.insert(this.getTableName(), null, ((AbstractDataObject)object).getValuesForInsert());
        ((AbstractDataObject)object).setRowId(rowId);
        return rowId;
    }

    public boolean deleteRow(long rowid) {
        return this.database.delete(this.getTableName(), "rowid = " + rowid, null) == 1;
    }

    public int deleteRows(String[] selectionFields, String[] selectionValues) {
        try {
            String whereClause = AbstractDataSource.getWhereClause(selectionFields, selectionValues);
            return this.database.delete(this.getTableName(), whereClause, null);
        }
        catch (IllegalArgumentException e) {
            MAPLog.e(this.getLogTag(), "" + e.getMessage(), e);
            return 0;
        }
    }

    protected int deleteRowsBySingleColumn(String colName, String colValue) {
        return this.deleteRows(new String[]{colName}, new String[]{colValue});
    }

    public int deleteAllRows() {
        return this.deleteRows(null, null);
    }

    public boolean updateRow(long rowid, ContentValues toUpdate) {
        if (toUpdate == null) {
            return false;
        }
        return this.database.update(this.getTableName(), toUpdate, "rowid = " + rowid, null) == 1;
    }

    private static String getWhereClause(String[] selectionFields, String[] selectionValues) throws IllegalArgumentException {
        if (selectionFields == null && selectionValues == null) {
            return null;
        }
        if (selectionFields == null || selectionValues == null) {
            throw new IllegalArgumentException("Both arguments have to be either null or not null!");
        }
        if (selectionFields.length != selectionValues.length) {
            throw new IllegalArgumentException("selectionFields and selectionValues differ in length!");
        }
        String to_return = "";
        for (int i = 0; i < selectionFields.length; ++i) {
            to_return = to_return + selectionFields[i] + (selectionValues[i] == null ? " IS NULL" : " = '" + selectionValues[i] + "'");
            to_return = to_return + (i != selectionFields.length - 1 ? " AND " : "");
        }
        return to_return;
    }

    public abstract String getLogTag();

    public abstract K cursorToObject(Cursor var1);

    public abstract String getTableName();

    public abstract String[] getAllColumns();

    public int getColumnIndex(Cursor cursor, int colIndex) throws IllegalArgumentException {
        assert (cursor != null);
        if (colIndex < 0 || colIndex >= this.getAllColumns().length) {
            throw new IllegalArgumentException("colIndex is out of bound!");
        }
        return cursor.getColumnIndexOrThrow(this.getAllColumns()[colIndex]);
    }
}

