/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.dataobject;

import android.content.ContentValues;
import android.content.Context;
import android.text.TextUtils;
import com.amazon.identity.auth.device.dataobject.AbstractDataObject;
import com.amazon.identity.auth.device.dataobject.Scope;
import com.amazon.identity.auth.device.datastore.AppInfoDataSource;
import com.amazon.identity.auth.device.utils.MAPUtils;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class AppInfo
extends AbstractDataObject {
    private static final String LOG_TAG = AppInfo.class.getName();
    public static final String[] ALL_COLUMNS = new String[]{"rowid", "AppFamilyId", "PackageName", "AllowedScopes", "GrantedPermissions", "ClientId", "AppVariantId", "AuthzHost", "ExchangeHost", "Payload"};
    public static final String DELIM = ",";
    private String appFamilyId;
    private String appVariantId;
    private String packageName;
    private String clientId;
    private String mAuthzHost;
    private String mExchangeHost;
    private String[] allowedScopes;
    private String[] grantedPermissions;
    private JSONObject payload;

    public AppInfo(String appFamilyId, String appVariantId, String packageName, String[] allowedScopes, String[] grantedPermissions, String clientId, String authzHost, String exchangeHost, JSONObject payload) {
        this.appFamilyId = appFamilyId;
        this.appVariantId = appVariantId;
        this.packageName = packageName;
        this.allowedScopes = allowedScopes;
        this.grantedPermissions = grantedPermissions;
        this.clientId = clientId;
        this.payload = payload;
        this.mAuthzHost = authzHost;
        this.mExchangeHost = exchangeHost;
    }

    private AppInfo(long rowid, String appFamilyId, String appVariantId, String packageName, String[] allowedScopes, String[] grantedPermissions, String clientId, String authzHost, String exchangeHost, JSONObject payload) {
        this(appFamilyId, appVariantId, packageName, allowedScopes, grantedPermissions, clientId, authzHost, exchangeHost, payload);
        this.setRowId(rowid);
    }

    public AppInfo() {
    }

    public String getAppFamilyId() {
        return this.appFamilyId;
    }

    public String getAppVariantId() {
        return this.appVariantId;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String[] getAllowedScopes() {
        return this.allowedScopes;
    }

    public String[] getGrantedPermissions() {
        return this.grantedPermissions;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getAuthorizationHost() {
        return this.mAuthzHost;
    }

    public String getExchangeHost() {
        return this.mExchangeHost;
    }

    private JSONObject getPayload() {
        return this.payload;
    }

    public void setAppFamilyId(String appFamilyId) {
        this.appFamilyId = appFamilyId;
    }

    public void setAppVariantId(String appVariantId) {
        this.appVariantId = appVariantId;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setAllowedScopes(String[] allowedScopes) {
        this.allowedScopes = allowedScopes;
    }

    public void setGrantedPermissions(String[] grantedPermissions) {
        this.grantedPermissions = grantedPermissions;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setAuthorizationHost(String authzHost) {
        this.mAuthzHost = authzHost;
    }

    public void setExchangeHost(String exchangeHost) {
        this.mExchangeHost = exchangeHost;
    }

    public void setPayload(JSONObject payload) {
        this.payload = payload;
    }

    public void setPayload(String payloadString) {
        try {
            this.payload = new JSONObject(payloadString);
        }
        catch (JSONException e) {
            MAPLog.e(LOG_TAG, "Payload String not correct JSON.  Setting payload to null", e);
        }
    }

    public String[] getAllowedRemoteScopes() {
        if (this.allowedScopes == null) {
            return null;
        }
        ArrayList<String> to_return = new ArrayList<String>();
        for (String scope : this.allowedScopes) {
            if (Scope.isLocal(scope)) continue;
            to_return.add(scope);
        }
        return to_return.toArray(new String[to_return.size()]);
    }

    public String getAttributeByKey(String key) {
        try {
            return this.payload.getString(key);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public String getVersion() {
        String version = this.getAttributeByKey("ver");
        return version != null ? version : "1";
    }

    public ContentValues getValuesForInsert() {
        ContentValues to_return = new ContentValues();
        to_return.put(ALL_COLUMNS[COL_INDEX.APP_FAMILY_ID.colId], this.appFamilyId);
        to_return.put(ALL_COLUMNS[COL_INDEX.PACKAGE_NAME.colId], this.packageName);
        to_return.put(ALL_COLUMNS[COL_INDEX.ALLOWED_SCOPES.colId], MAPUtils.toDelimitedString(this.allowedScopes, DELIM));
        to_return.put(ALL_COLUMNS[COL_INDEX.GRANTED_PERMISSIONS.colId], MAPUtils.toDelimitedString(this.grantedPermissions, DELIM));
        to_return.put(ALL_COLUMNS[COL_INDEX.CLIENT_ID.colId], this.clientId);
        to_return.put(ALL_COLUMNS[COL_INDEX.APP_VARIANT_ID.colId], this.appVariantId);
        to_return.put(ALL_COLUMNS[COL_INDEX.AUTHZ_HOST.colId], this.mAuthzHost);
        to_return.put(ALL_COLUMNS[COL_INDEX.EXCHANGE_HOST.colId], this.mExchangeHost);
        to_return.put(ALL_COLUMNS[COL_INDEX.PAYLOAD.colId], this.payload != null ? this.payload.toString() : null);
        return to_return;
    }

    public AppInfoDataSource getDataSource(Context context) {
        return AppInfoDataSource.getInstance(context);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AppInfo) {
            AppInfo appInfo = (AppInfo)obj;
            return TextUtils.equals((CharSequence)this.appFamilyId, (CharSequence)appInfo.getAppFamilyId()) && TextUtils.equals((CharSequence)this.appVariantId, (CharSequence)appInfo.getAppVariantId()) && TextUtils.equals((CharSequence)this.packageName, (CharSequence)appInfo.getPackageName()) && Arrays.equals(this.allowedScopes, appInfo.getAllowedScopes()) && Arrays.equals(this.grantedPermissions, appInfo.getGrantedPermissions()) && TextUtils.equals((CharSequence)this.clientId, (CharSequence)appInfo.getClientId()) && TextUtils.equals((CharSequence)this.mAuthzHost, (CharSequence)appInfo.getAuthorizationHost()) && TextUtils.equals((CharSequence)this.mExchangeHost, (CharSequence)appInfo.getExchangeHost()) && this.payloadEquals(appInfo);
        }
        return false;
    }

    private boolean payloadEquals(AppInfo appInfo) {
        JSONObject otherPayload = appInfo.getPayload();
        if (this.payload == null) {
            return otherPayload == null;
        }
        if (otherPayload == null) {
            return false;
        }
        Iterator itr = this.payload.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            try {
                if (this.payload.getString(key).equals(otherPayload.getString(key))) continue;
                MAPLog.e(LOG_TAG, "APIKeys not equal: key " + key + " not equal");
                return false;
            }
            catch (JSONException jsone) {
                MAPLog.e(LOG_TAG, "APIKeys not equal: JSONException", jsone);
                return false;
            }
            catch (ClassCastException cce) {
                MAPLog.e(LOG_TAG, "APIKeys not equal: ClassCastExceptionException", cce);
                return false;
            }
        }
        return true;
    }

    public AppInfo clone() {
        return new AppInfo(this.getRowId(), this.appFamilyId, this.appVariantId, this.packageName, this.allowedScopes, this.grantedPermissions, this.clientId, this.mAuthzHost, this.mExchangeHost, this.payload);
    }

    public String toString() {
        try {
            return this.payload.toString(4);
        }
        catch (Exception e) {
            return "{ rowid=" + this.getRowId() + ", appFamilyId=" + this.appFamilyId + ", appVariantId=" + this.appVariantId + ", packageName=" + this.packageName + ", allowedScopes=" + Arrays.toString(this.allowedScopes) + ", grantedPermissions=" + Arrays.toString(this.grantedPermissions) + ", clientId=" + this.clientId + ", AuthzHost=" + this.mAuthzHost + ", ExchangeHost=" + this.mExchangeHost + " }";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum COL_INDEX {
        ROW_ID(0),
        APP_FAMILY_ID(1),
        PACKAGE_NAME(2),
        ALLOWED_SCOPES(3),
        GRANTED_PERMISSIONS(4),
        CLIENT_ID(5),
        APP_VARIANT_ID(6),
        AUTHZ_HOST(7),
        EXCHANGE_HOST(8),
        PAYLOAD(9);

        public final int colId;

        private COL_INDEX(int colId) {
            this.colId = colId;
        }
    }
}

