/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.authorization;

import android.content.Context;
import android.os.Bundle;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.appid.AppIdentifier;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.endpoint.ServerCommunication;
import com.amazon.identity.auth.device.endpoint.TokenVendor;
import com.amazon.identity.auth.device.service.MAPServiceResult;
import com.amazon.identity.auth.device.shared.APIListener;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import java.util.Arrays;

public final class TokenHelper {
    private static final String LOG_TAG = TokenHelper.class.getName();
    private static TokenVendor mTokenVendor = new TokenVendor();

    private TokenHelper() {
    }

    static void setServerCommunicaton(ServerCommunication serverCommunication) {
        mTokenVendor.setServerCommunication(serverCommunication);
    }

    public static void getToken(Context context, String packageName, String clientId, String[] scopes, APIListener listener, AppIdentifier appIdentifier, Bundle options) throws AuthError {
        MAPLog.pii(LOG_TAG, "GetToken pkg=" + packageName + " scopes=" + Arrays.toString(scopes), "clientId=" + clientId);
        AppInfo appInfo = appIdentifier.getAppInfo(packageName, context);
        if (appInfo == null) {
            MAPLog.e(LOG_TAG, "appInfo is null for " + packageName);
            listener.onError(new AuthError("APIKey info is unavailable for " + packageName, null, AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED));
            return;
        }
        String directedId = null;
        try {
            String authzToken = mTokenVendor.vendToken(directedId, scopes, context, options, appInfo);
            MAPLog.pii(LOG_TAG, "GetToken", "id=" + directedId + " appid=" + appInfo.getAppFamilyId() + " atzToken=" + authzToken);
            listener.onSuccess(MAPServiceResult.getOnSuccessBundle(AuthzConstants.BUNDLE_KEY.TOKEN.val, authzToken));
        }
        catch (IOException e) {
            MAPLog.e(LOG_TAG, "" + e.getMessage(), e);
            listener.onError(new AuthError("Error communicating with server!", e, AuthError.ERROR_TYPE.ERROR_IO));
        }
    }
}

