/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.dataobject;

import android.content.ContentValues;
import android.content.Context;
import com.amazon.identity.auth.device.datastore.AbstractDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataObject {
    public static final int NON_EXISTENT_ROW = -1;
    private long rowId = -1L;

    public abstract ContentValues getValuesForInsert();

    public long getRowId() {
        return this.rowId;
    }

    public void setRowId(long rowId) {
        this.rowId = rowId;
    }

    public long insert(Context context) {
        return this.getDataSource(context).insertRow(this);
    }

    public boolean update(Context context) {
        return this.getDataSource(context).updateRow(this.getRowId(), this.getValuesForInsert());
    }

    public boolean insertOrUpdate(Context context) {
        if (this.getRowId() == -1L) {
            return this.getDataSource(context).insertRow(this) != -1L;
        }
        return this.getDataSource(context).updateRow(this.getRowId(), this.getValuesForInsert());
    }

    public boolean delete(Context context) {
        boolean deleteSuccess = this.getDataSource(context).deleteRow(this.getRowId());
        if (deleteSuccess) {
            this.setRowId(-1L);
        }
        return deleteSuccess;
    }

    public abstract <K extends AbstractDataObject> AbstractDataSource<K> getDataSource(Context var1);

    public String toString() {
        return "rowid = " + this.getRowId() + "|" + this.getValuesForInsert().toString();
    }

    public abstract boolean equals(Object var1);

    protected boolean areObjectsEqual(Object obj1, Object obj2) {
        if (obj1 != null && obj2 != null) {
            return obj1.equals(obj2);
        }
        return false;
    }
}

