/*
 * Decompiled with CFR 0.152.
 */
package com.willblaschko.android.alexa.interfaces.system;

import android.util.Log;
import com.willblaschko.android.alexa.callbacks.AsyncCallback;
import com.willblaschko.android.alexa.connection.ClientUtil;
import com.willblaschko.android.alexa.interfaces.AvsResponse;
import com.willblaschko.android.alexa.interfaces.SendEvent;
import com.willblaschko.android.alexa.interfaces.response.ResponseParser;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

public class OpenDownchannel
extends SendEvent {
    private static final String TAG = "OpenDownchannel";
    private Call currentCall;
    private OkHttpClient client;
    private String url;
    private AsyncCallback<AvsResponse, Exception> callback;

    public OpenDownchannel(String url, AsyncCallback<AvsResponse, Exception> callback) {
        this.callback = callback;
        this.url = url;
        this.client = ClientUtil.getTLS12OkHttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String accessToken) throws IOException {
        if (this.callback != null) {
            this.callback.start();
        }
        Request request = new Request.Builder().url(this.url).addHeader("Authorization", "Bearer " + accessToken).build();
        Response response = null;
        long start = System.currentTimeMillis();
        try {
            this.currentCall = this.client.newCall(request);
            response = this.currentCall.execute();
            String boundary = this.getBoundary(response);
            BufferedSource source = response.body().source();
            Buffer buffer = new Buffer();
            while (!source.exhausted()) {
                source.read(buffer, 8192L);
                AvsResponse val = new AvsResponse();
                try {
                    val = ResponseParser.parseResponse(buffer.inputStream(), boundary, true);
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
                if (this.callback == null) continue;
                this.callback.success(val);
            }
            Log.i((String)TAG, (String)"Downchannel open");
            Log.i((String)TAG, (String)("Open Downchannel process took: " + (System.currentTimeMillis() - start)));
        }
        catch (IOException e) {
            this.onError(this.callback, e);
        }
        finally {
            if (response != null) {
                response.body().close();
            }
        }
    }

    public void closeConnection() {
        if (this.currentCall != null && !this.currentCall.isCanceled()) {
            this.currentCall.cancel();
        }
    }

    private void onError(AsyncCallback<AvsResponse, Exception> callback, Exception e) {
        if (callback != null) {
            callback.failure(e);
            callback.complete();
        }
    }

    @Override
    @NotNull
    protected String getEvent() {
        return "";
    }
}

