/*
 * Decompiled with CFR 0.152.
 */
package com.willblaschko.android.alexa;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Handler;
import com.google.android.gms.security.ProviderInstaller;
import com.willblaschko.android.alexa.AuthorizationManager;
import com.willblaschko.android.alexa.R;
import com.willblaschko.android.alexa.TokenManager;
import com.willblaschko.android.alexa.VoiceHelper;
import com.willblaschko.android.alexa.callbacks.AsyncCallback;
import com.willblaschko.android.alexa.callbacks.AuthorizationCallback;
import com.willblaschko.android.alexa.data.Event;
import com.willblaschko.android.alexa.interfaces.AvsException;
import com.willblaschko.android.alexa.interfaces.AvsItem;
import com.willblaschko.android.alexa.interfaces.AvsResponse;
import com.willblaschko.android.alexa.interfaces.GenericSendEvent;
import com.willblaschko.android.alexa.interfaces.audioplayer.AvsPlayAudioItem;
import com.willblaschko.android.alexa.interfaces.speechrecognizer.SpeechSendAudio;
import com.willblaschko.android.alexa.interfaces.speechrecognizer.SpeechSendText;
import com.willblaschko.android.alexa.interfaces.speechrecognizer.SpeechSendVoice;
import com.willblaschko.android.alexa.interfaces.speechsynthesizer.AvsSpeakItem;
import com.willblaschko.android.alexa.interfaces.system.OpenDownchannel;
import com.willblaschko.android.alexa.requestbody.DataRequestBody;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import okio.BufferedSink;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongycastle.jce.provider.BouncyCastleProvider;

public class AlexaManager {
    private static final String TAG = "AlexaManager";
    private static AlexaManager mInstance;
    private AuthorizationManager mAuthorizationManager;
    private SpeechSendVoice mSpeechSendVoice;
    private SpeechSendText mSpeechSendText;
    private SpeechSendAudio mSpeechSendAudio;
    private OpenDownchannel openDownchannel;
    private VoiceHelper mVoiceHelper;
    private Context mContext;
    private boolean mIsRecording = false;
    private Handler post = new Handler();
    private ProviderInstaller.ProviderInstallListener providerInstallListener = new ProviderInstaller.ProviderInstallListener(){

        public void onProviderInstalled() {
        }

        public void onProviderInstallFailed(int errorCode, Intent recoveryIntent) {
        }
    };

    private AlexaManager(Context context, String productId) {
        this.mContext = context.getApplicationContext();
        this.mAuthorizationManager = new AuthorizationManager(this.mContext, productId);
        this.mVoiceHelper = VoiceHelper.getInstance(this.mContext);
        ProviderInstaller.installIfNeededAsync((Context)context, (ProviderInstaller.ProviderInstallListener)this.providerInstallListener);
    }

    public static AlexaManager getInstance(Context context, String productId) {
        if (mInstance == null) {
            mInstance = new AlexaManager(context, productId);
        }
        return mInstance;
    }

    public SpeechSendVoice getSpeechSendVoice() {
        if (this.mSpeechSendVoice == null) {
            this.mSpeechSendVoice = new SpeechSendVoice();
        }
        return this.mSpeechSendVoice;
    }

    public SpeechSendText getSpeechSendText() {
        if (this.mSpeechSendText == null) {
            this.mSpeechSendText = new SpeechSendText();
        }
        return this.mSpeechSendText;
    }

    public SpeechSendAudio getSpeechSendAudio() {
        if (this.mSpeechSendAudio == null) {
            this.mSpeechSendAudio = new SpeechSendAudio();
        }
        return this.mSpeechSendAudio;
    }

    public VoiceHelper getVoiceHelper() {
        return this.mVoiceHelper;
    }

    public void checkLoggedIn(final @NotNull AsyncCallback<Boolean, Throwable> callback) {
        this.mAuthorizationManager.checkLoggedIn(this.mContext, new AsyncCallback<Boolean, Throwable>(){

            @Override
            public void start() {
            }

            @Override
            public void success(Boolean result) {
                callback.success(result);
            }

            @Override
            public void failure(Throwable error) {
                callback.failure(error);
            }

            @Override
            public void complete() {
            }
        });
    }

    public void logIn(final @Nullable AuthorizationCallback callback) {
        this.mAuthorizationManager.checkLoggedIn(this.mContext, new AsyncCallback<Boolean, Throwable>(){

            @Override
            public void start() {
            }

            @Override
            public void success(Boolean result) {
                if (result.booleanValue()) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                } else {
                    AlexaManager.this.mAuthorizationManager.authorizeUser(callback);
                }
            }

            @Override
            public void failure(Throwable error) {
                if (callback != null) {
                    callback.onError(new Exception(error));
                }
            }

            @Override
            public void complete() {
            }
        });
    }

    public void closeOpenDownchannel() {
        if (this.openDownchannel != null) {
            this.openDownchannel.closeConnection();
            this.openDownchannel = null;
        }
    }

    public void sendOpenDownchannelDirective(final @Nullable AsyncCallback<AvsResponse, Exception> callback) {
        if (this.openDownchannel != null) {
            return;
        }
        this.openDownchannel = new OpenDownchannel(this.getDirectivesUrl(), new AsyncEventHandler(this, callback));
        this.mAuthorizationManager.checkLoggedIn(this.mContext, new ImplCheckLoggedInCallback(){

            @Override
            public void success(Boolean result) {
                if (result.booleanValue()) {
                    String url = AlexaManager.this.getDirectivesUrl();
                    TokenManager.getAccessToken(AlexaManager.this.mAuthorizationManager.getAmazonAuthorizationManager(), AlexaManager.this.mContext, new TokenManager.TokenCallback(){

                        @Override
                        public void onSuccess(final String token) {
                            new AsyncTask<Void, Void, AvsResponse>(){

                                protected AvsResponse doInBackground(Void ... params) {
                                    try {
                                        if (AlexaManager.this.openDownchannel != null) {
                                            AlexaManager.this.openDownchannel.connect(token);
                                        }
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                    return null;
                                }

                                protected void onPostExecute(AvsResponse avsResponse) {
                                    super.onPostExecute((Object)avsResponse);
                                    AlexaManager.this.openDownchannel = null;
                                    AlexaManager.this.post.postDelayed(new Runnable(){

                                        @Override
                                        public void run() {
                                            AlexaManager.this.sendOpenDownchannelDirective(callback);
                                        }
                                    }, 5000L);
                                }
                            }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
                        }

                        @Override
                        public void onFailure(Throwable e) {
                        }
                    });
                } else {
                    AlexaManager.this.logIn(new ImplAuthorizationCallback<AvsResponse>(null){

                        @Override
                        public void onSuccess() {
                            AlexaManager.this.sendOpenDownchannelDirective(this.callback);
                        }
                    });
                }
            }
        });
    }

    public void sendSynchronizeStateEvent(@Nullable AsyncCallback<AvsResponse, Exception> callback) {
        this.sendEvent(Event.getSynchronizeStateEvent(), callback);
    }

    public boolean hasOpenDownchannel() {
        return this.openDownchannel != null;
    }

    public boolean isRecording() {
        return this.mIsRecording;
    }

    @Deprecated
    public void startRecording(int requestType, @Nullable AsyncCallback<Void, Exception> callback) throws IOException {
        this.startRecording((byte[])null, callback);
    }

    @Deprecated
    public void startRecording(@Nullable AsyncCallback<Void, Exception> callback) {
        this.startRecording((byte[])null, callback);
    }

    @Deprecated
    public void startRecording(int requestType, @Nullable String assetFile, @Nullable AsyncCallback<Void, Exception> callback) throws IOException {
        this.startRecording(assetFile, callback);
    }

    @Deprecated
    public void startRecording(@Nullable String assetFile, @Nullable AsyncCallback<Void, Exception> callback) throws IOException {
        byte[] bytes = null;
        if (assetFile != null) {
            InputStream input = this.mContext.getAssets().open(assetFile);
            bytes = IOUtils.toByteArray((InputStream)input);
            input.close();
        }
        this.startRecording(bytes, callback);
    }

    @Deprecated
    public void startRecording(int requestType, @Nullable byte[] assetFile, @Nullable AsyncCallback<Void, Exception> callback) {
        this.startRecording(assetFile, callback);
    }

    @Deprecated
    public void startRecording(final @Nullable byte[] assetFile, final @Nullable AsyncCallback<Void, Exception> callback) {
        this.mAuthorizationManager.checkLoggedIn(this.mContext, new ImplCheckLoggedInCallback(){

            @Override
            public void success(Boolean result) {
                if (result.booleanValue()) {
                    final String url = AlexaManager.this.getEventsUrl();
                    if (callback != null) {
                        callback.start();
                    }
                    new AsyncTask<Void, Void, Void>(){

                        protected Void doInBackground(Void ... params) {
                            TokenManager.getAccessToken(AlexaManager.this.mAuthorizationManager.getAmazonAuthorizationManager(), AlexaManager.this.mContext, new TokenManager.TokenCallback(){

                                @Override
                                public void onSuccess(String token) {
                                    try {
                                        AlexaManager.this.mIsRecording = true;
                                        AlexaManager.this.getSpeechSendVoice().startRecording(url, token, assetFile, callback);
                                        if (callback != null) {
                                            callback.success(null);
                                        }
                                    }
                                    catch (IOException e) {
                                        AlexaManager.this.mIsRecording = false;
                                        e.printStackTrace();
                                        if (callback != null) {
                                            callback.failure(e);
                                        }
                                    }
                                    finally {
                                        if (callback != null) {
                                            callback.complete();
                                        }
                                    }
                                }

                                @Override
                                public void onFailure(Throwable e) {
                                }
                            });
                            return null;
                        }
                    }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
                } else {
                    AlexaManager.this.logIn(new ImplAuthorizationCallback<Void>(callback){

                        @Override
                        public void onSuccess() {
                            AlexaManager.this.startRecording(assetFile, (AsyncCallback<Void, Exception>)this.callback);
                        }
                    });
                }
            }
        });
    }

    @Deprecated
    public void stopRecording(final @Nullable AsyncCallback<AvsResponse, Exception> callback) {
        if (!this.mIsRecording) {
            if (callback != null) {
                callback.failure(new RuntimeException("recording not started"));
            }
            return;
        }
        this.mIsRecording = false;
        if (callback != null) {
            callback.start();
        }
        new AsyncTask<Void, Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doInBackground(Void ... params) {
                try {
                    AvsResponse response = AlexaManager.this.getSpeechSendVoice().stopRecording();
                    try {
                        if (callback != null) {
                            callback.success(response);
                            callback.complete();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callback != null) {
                            callback.failure(e);
                            callback.complete();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (callback != null) {
                        callback.failure(e);
                    }
                }
                catch (AvsException e) {
                    e.printStackTrace();
                    if (callback != null) {
                        callback.failure(e);
                    }
                }
                finally {
                    if (callback != null) {
                        callback.complete();
                    }
                }
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    @Deprecated
    public void sendTextRequest(int requestType, String text, @Nullable AsyncCallback<AvsResponse, Exception> callback) {
        this.sendTextRequest(text, callback);
    }

    public void sendTextRequest(final String text, final @Nullable AsyncCallback<AvsResponse, Exception> callback) {
        this.mAuthorizationManager.checkLoggedIn(this.mContext, new ImplCheckLoggedInCallback(){

            @Override
            public void success(Boolean result) {
                if (result.booleanValue()) {
                    final String url = AlexaManager.this.getEventsUrl();
                    new AsyncTask<Void, Void, AvsResponse>(){

                        protected AvsResponse doInBackground(Void ... params) {
                            TokenManager.getAccessToken(AlexaManager.this.mAuthorizationManager.getAmazonAuthorizationManager(), AlexaManager.this.mContext, new TokenManager.TokenCallback(){

                                @Override
                                public void onSuccess(String token) {
                                    block2: {
                                        try {
                                            AlexaManager.this.getSpeechSendText().sendText(AlexaManager.this.mContext, url, token, text, new AsyncEventHandler(AlexaManager.this, callback));
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            if (callback == null) break block2;
                                            callback.failure(e);
                                        }
                                    }
                                }

                                @Override
                                public void onFailure(Throwable e) {
                                }
                            });
                            return null;
                        }

                        protected void onPostExecute(AvsResponse avsResponse) {
                            super.onPostExecute((Object)avsResponse);
                        }
                    }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
                } else {
                    AlexaManager.this.logIn(new ImplAuthorizationCallback<AvsResponse>(callback){

                        @Override
                        public void onSuccess() {
                            AlexaManager.this.sendTextRequest(text, this.callback);
                        }
                    });
                }
            }
        });
    }

    @Deprecated
    public void sendAudioRequest(int requestType, byte[] data, AsyncCallback<AvsResponse, Exception> callback) {
        this.sendAudioRequest(data, callback);
    }

    public void sendAudioRequest(final byte[] data, @Nullable AsyncCallback<AvsResponse, Exception> callback) {
        this.sendAudioRequest(new DataRequestBody(){

            public void writeTo(BufferedSink sink) throws IOException {
                sink.write(data);
            }
        }, callback);
    }

    public void sendAudioRequest(final DataRequestBody requestBody, final @Nullable AsyncCallback<AvsResponse, Exception> callback) {
        this.mAuthorizationManager.checkLoggedIn(this.mContext, new ImplCheckLoggedInCallback(){

            @Override
            public void success(Boolean result) {
                if (result.booleanValue()) {
                    final String url = AlexaManager.this.getEventsUrl();
                    TokenManager.getAccessToken(AlexaManager.this.mAuthorizationManager.getAmazonAuthorizationManager(), AlexaManager.this.mContext, new TokenManager.TokenCallback(){

                        @Override
                        public void onSuccess(final String token) {
                            new AsyncTask<Void, Void, AvsResponse>(){

                                protected AvsResponse doInBackground(Void ... params) {
                                    block2: {
                                        try {
                                            AlexaManager.this.getSpeechSendAudio().sendAudio(url, token, requestBody, new AsyncEventHandler(AlexaManager.this, callback));
                                        }
                                        catch (IOException e) {
                                            e.printStackTrace();
                                            if (callback == null) break block2;
                                            callback.failure(e);
                                        }
                                    }
                                    return null;
                                }

                                protected void onPostExecute(AvsResponse avsResponse) {
                                    super.onPostExecute((Object)avsResponse);
                                }
                            }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
                        }

                        @Override
                        public void onFailure(Throwable e) {
                        }
                    });
                } else {
                    AlexaManager.this.logIn(new ImplAuthorizationCallback<AvsResponse>(callback){

                        @Override
                        public void onSuccess() {
                            AlexaManager.this.sendAudioRequest(requestBody, (AsyncCallback<AvsResponse, Exception>)this.callback);
                        }
                    });
                }
            }
        });
    }

    public void cancelAudioRequest() {
        this.mAuthorizationManager.checkLoggedIn(this.mContext, new ImplCheckLoggedInCallback(){

            @Override
            public void success(Boolean result) {
                if (result.booleanValue()) {
                    AlexaManager.this.getSpeechSendAudio().cancelRequest();
                }
            }
        });
    }

    public void sendVolumeChangedEvent(long volume, boolean isMute, @Nullable AsyncCallback<AvsResponse, Exception> callback) {
        this.sendEvent(Event.getVolumeChangedEvent(volume, isMute), callback);
    }

    public void sendMutedEvent(boolean isMute, @Nullable AsyncCallback<AvsResponse, Exception> callback) {
        this.sendEvent(Event.getMuteEvent(isMute), callback);
    }

    public void sendExpectSpeechTimeoutEvent(AsyncCallback<AvsResponse, Exception> callback) {
        this.sendEvent(Event.getExpectSpeechTimedOutEvent(), callback);
    }

    public void sendPlaybackNearlyFinishedEvent(AvsItem item, long offsetMilliseconds, AsyncCallback<AvsResponse, Exception> callback) {
        if (item == null || !this.isAudioPlayItem(item)) {
            return;
        }
        this.sendEvent(Event.getPlaybackNearlyFinishedEvent(item.getToken(), offsetMilliseconds), callback);
    }

    public void sendPlaybackStartedEvent(AvsItem item, AsyncCallback<AvsResponse, Exception> callback) {
        String event;
        if (item == null) {
            return;
        }
        try {
            event = item instanceof AvsSpeakItem ? Event.getSpeechStartedEvent(item.getToken()) : Event.getPlaybackStartedEvent(item.getToken());
        }
        catch (NullPointerException e) {
            if (callback != null) {
                callback.failure(e);
            }
            return;
        }
        this.sendEvent(event, callback);
    }

    public void sendPlaybackFinishedEvent(AvsItem item, AsyncCallback<AvsResponse, Exception> callback) {
        if (item == null) {
            return;
        }
        String event = this.isAudioPlayItem(item) ? Event.getPlaybackFinishedEvent(item.getToken()) : Event.getSpeechFinishedEvent(item.getToken());
        this.sendEvent(event, callback);
    }

    public void sendEvent(final String event, final AsyncCallback<AvsResponse, Exception> callback) {
        this.mAuthorizationManager.checkLoggedIn(this.mContext, new ImplCheckLoggedInCallback(){

            @Override
            public void success(Boolean result) {
                if (result.booleanValue()) {
                    final String url = AlexaManager.this.getEventsUrl();
                    TokenManager.getAccessToken(AlexaManager.this.mAuthorizationManager.getAmazonAuthorizationManager(), AlexaManager.this.mContext, new TokenManager.TokenCallback(){

                        @Override
                        public void onSuccess(final String token) {
                            new AsyncTask<Void, Void, AvsResponse>(){

                                protected AvsResponse doInBackground(Void ... params) {
                                    new GenericSendEvent(url, token, event, new AsyncEventHandler(AlexaManager.this, callback));
                                    return null;
                                }

                                protected void onPostExecute(AvsResponse avsResponse) {
                                    super.onPostExecute((Object)avsResponse);
                                }
                            }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
                        }

                        @Override
                        public void onFailure(Throwable e) {
                        }
                    });
                } else {
                    AlexaManager.this.logIn(new ImplAuthorizationCallback<AvsResponse>(callback){

                        @Override
                        public void onSuccess() {
                            AlexaManager.this.sendEvent(event, this.callback);
                        }
                    });
                }
            }
        });
    }

    private boolean isAudioPlayItem(AvsItem item) {
        return item != null && (item instanceof AvsPlayAudioItem || !(item instanceof AvsSpeakItem));
    }

    private String getEventsUrl() {
        return this.mContext.getString(R.string.alexa_api) + "/" + this.mContext.getString(R.string.alexa_api_version) + "/" + "events";
    }

    private String getDirectivesUrl() {
        return this.mContext.getString(R.string.alexa_api) + "/" + this.mContext.getString(R.string.alexa_api_version) + "/" + "directives";
    }

    static {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
    }

    private static abstract class ImplCheckLoggedInCallback
    implements AsyncCallback<Boolean, Throwable> {
        private ImplCheckLoggedInCallback() {
        }

        @Override
        public void start() {
        }

        @Override
        public void failure(Throwable error) {
        }

        @Override
        public void complete() {
        }
    }

    private static abstract class ImplAuthorizationCallback<E>
    implements AuthorizationCallback {
        AsyncCallback<E, Exception> callback;

        public ImplAuthorizationCallback(AsyncCallback<E, Exception> callback) {
            this.callback = callback;
        }

        @Override
        public void onCancel() {
        }

        @Override
        public void onError(Exception error) {
            if (this.callback != null) {
                this.callback.failure(error);
            }
        }
    }

    private static class AsyncEventHandler
    implements AsyncCallback<AvsResponse, Exception> {
        AsyncCallback<AvsResponse, Exception> callback;
        AlexaManager manager;

        public AsyncEventHandler(AlexaManager manager, AsyncCallback<AvsResponse, Exception> callback) {
            this.callback = callback;
            this.manager = manager;
        }

        @Override
        public void start() {
            if (this.callback != null) {
                this.callback.start();
            }
        }

        @Override
        public void success(AvsResponse result) {
            if (this.callback != null) {
                this.callback.success(result);
            }
        }

        @Override
        public void failure(Exception error) {
            if (this.callback != null) {
                this.callback.failure(error);
            }
        }

        @Override
        public void complete() {
            if (this.callback != null) {
                this.callback.complete();
            }
            this.manager.mSpeechSendAudio = null;
            this.manager.mSpeechSendVoice = null;
            this.manager.mSpeechSendText = null;
        }
    }
}

