/*
 * Decompiled with CFR 0.152.
 */
package com.willblaschko.android.alexa.connection;

import com.willblaschko.android.alexa.connection.TLSSocketFactoryCompat;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import okhttp3.TlsVersion;

public class ClientUtil {
    private static OkHttpClient mClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OkHttpClient getTLS12OkHttpClient() {
        if (mClient == null) {
            OkHttpClient client = null;
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)null);
                Object[] trustManagers = trustManagerFactory.getTrustManagers();
                if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                    throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
                }
                X509TrustManager trustManager = (X509TrustManager)trustManagers[0];
                SSLContext sc = SSLContext.getInstance("TLSv1.2");
                sc.init(null, null, null);
                ConnectionSpec cs = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2}).build();
                ArrayList<ConnectionSpec> specs = new ArrayList<ConnectionSpec>();
                specs.add(cs);
                client = new OkHttpClient.Builder().sslSocketFactory((SSLSocketFactory)new TLSSocketFactoryCompat(), trustManager).connectionSpecs(specs).build();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
            finally {
                if (client == null) {
                    client = new OkHttpClient();
                }
            }
            mClient = client;
        }
        return mClient;
    }
}

