/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.authorization;

import android.content.ComponentName;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.IInterface;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.authorization.AmazonServiceListener;
import com.amazon.identity.auth.map.device.utils.MAPLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MAPServiceConnection<T>
implements ServiceConnection {
    private static final String LOG_TAG = MAPServiceConnection.class.getName();
    protected IInterface mService = null;
    protected AmazonServiceListener mListener;

    public void onServiceConnected(ComponentName name, IBinder service) {
        MAPLog.i(LOG_TAG, "onServiceConnected called");
        if (this.isValidService(service)) {
            this.mService = this.getServiceInterface(service);
            this.mListener.onBindSuccess(this.mService);
        } else {
            this.mListener.onBindError(new AuthError("Returned service's interface doesn't match authorization service", AuthError.ERROR_TYPE.ERROR_UNKNOWN));
        }
    }

    public void setServiceListener(AmazonServiceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null!");
        }
        this.mListener = listener;
    }

    public void onServiceDisconnected(ComponentName name) {
        MAPLog.i(LOG_TAG, "onServiceDisconnected called");
        this.mService = null;
    }

    protected boolean isValidService(IBinder service) {
        try {
            return service.getInterfaceDescriptor().equals(this.getServiceInterfaceClass().getName());
        }
        catch (Exception e) {
            MAPLog.e(LOG_TAG, "" + e.getMessage(), e);
            return false;
        }
    }

    public abstract IInterface getServiceInterface(IBinder var1);

    public abstract Class<T> getServiceInterfaceClass();
}

