/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.os.Bundle;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.endpoint.AbstractTokenRequest;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.Header;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;

public abstract class AbstractJSONTokenRequest
extends AbstractTokenRequest {
    private static final String APPLICATION_JSON_CONTENT_TYPE = "application/json";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String LOG_TAG = AbstractJSONTokenRequest.class.getName();

    public AbstractJSONTokenRequest(String appName, String appVersion, String libVersion, Bundle options) {
        super(appName, appVersion, libVersion, options);
    }

    public StringEntity getEntity() throws UnsupportedEncodingException, IOException {
        MAPLog.pii(LOG_TAG, "Generating StringEntity", "json=" + this.getJSONString());
        StringEntity stringEntity = new StringEntity(this.getJSONString());
        return stringEntity;
    }

    public abstract String getJSONString();

    public void initializeHeaders() throws AuthError {
        super.initializeHeaders();
        this.addHeader((Header)new BasicHeader(CONTENT_TYPE, APPLICATION_JSON_CONTENT_TYPE));
    }
}

