/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.datastore;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.amazon.identity.auth.device.dataobject.Profile;
import com.amazon.identity.auth.device.datastore.AbstractDataSource;
import com.amazon.identity.auth.device.datastore.DatabaseHelper;
import com.amazon.identity.auth.device.utils.MAPUtils;
import com.amazon.identity.auth.map.device.utils.MAPLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileDataSource
extends AbstractDataSource<Profile> {
    private static final String LOG_TAG = ProfileDataSource.class.getName();
    private static final String[] ALL_COLUMNS = Profile.ALL_COLUMNS;
    private static ProfileDataSource INSTANCE;

    public ProfileDataSource(SQLiteDatabase database) {
        super(database);
    }

    public static synchronized ProfileDataSource getInstance(Context context) {
        if (INSTANCE == null) {
            INSTANCE = new ProfileDataSource(MAPUtils.getMAPdatabase(context));
        }
        return INSTANCE;
    }

    public static void resetInstance() {
        INSTANCE = null;
        MAPUtils.resetDatabaseInstance();
    }

    @Override
    public String getLogTag() {
        return LOG_TAG;
    }

    @Override
    public String getTableName() {
        return "Profile";
    }

    @Override
    public String[] getAllColumns() {
        return ALL_COLUMNS;
    }

    @Override
    public Profile cursorToObject(Cursor cursor) {
        if (cursor == null || cursor.getCount() == 0) {
            return null;
        }
        try {
            Profile profile = new Profile();
            profile.setId(cursor.getLong(this.getColumnIndex(cursor, Profile.COL_INDEX.ID.colId)));
            profile.setAppId(cursor.getString(this.getColumnIndex(cursor, Profile.COL_INDEX.APP_ID.colId)));
            profile.setExpirationTime(DatabaseHelper.getDateFormat().parse(cursor.getString(this.getColumnIndex(cursor, Profile.COL_INDEX.EXPIRATION_TIME.colId))));
            profile.setData(cursor.getString(this.getColumnIndex(cursor, Profile.COL_INDEX.DATA.colId)));
            return profile;
        }
        catch (Exception e) {
            MAPLog.e(LOG_TAG, "" + e.getMessage(), e);
            return null;
        }
    }

    public Profile getProfile(String appId) {
        return (Profile)this.findOneRowBySingleColumn("AppId", appId);
    }
}

