/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Resources;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class ThirdPartyResourceParser {
    private static final String UTF_8 = "UTF-8";
    private static final String API_KEY_FILE = "api_key.txt";
    private static final String LOG_TAG = ThirdPartyResourceParser.class.getName();
    public static final String KEY_API_KEY = "APIKey";
    public static final String KEY_API_KEY_OLD = "AmazonAPIKey";
    private final String _packageName;
    private final Context _context;
    private final String _apiKey;
    public static final String UTF8_BYTE_ORDER_MARK = "\ufeff";

    public ThirdPartyResourceParser(Context context, String packageName) {
        this._packageName = packageName;
        this._context = context;
        this._apiKey = this.parseApiKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseApiKey() {
        block9: {
            if (this._context != null) {
                String string;
                block8: {
                    InputStream is = null;
                    try {
                        Resources resources = this._context.getPackageManager().getResourcesForApplication(this.getPackageName());
                        AssetManager assetManager = resources.getAssets();
                        is = assetManager.open(this.getApiKeyFile());
                        MAPLog.i(LOG_TAG, "Attempting to parse API Key from assets directory");
                        string = ThirdPartyResourceParser.readString(is);
                        if (is == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                is.close();
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            MAPLog.i(LOG_TAG, "Unable to get api key asset document: " + e.getMessage());
                            break block9;
                        }
                        catch (PackageManager.NameNotFoundException e) {
                            MAPLog.i(LOG_TAG, "Unable to get api key asset document: " + e.getMessage());
                        }
                    }
                    is.close();
                }
                return string;
            }
        }
        return null;
    }

    protected String getApiKeyFile() {
        return API_KEY_FILE;
    }

    protected String getPackageName() {
        return this._packageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readString(InputStream is) throws IOException {
        String result = null;
        InputStreamReader r = null;
        BufferedReader br = null;
        try {
            r = new InputStreamReader(is, UTF_8);
            br = new BufferedReader(r);
            result = br.readLine();
            if (result.startsWith(UTF8_BYTE_ORDER_MARK)) {
                result = result.substring(1);
            }
        }
        catch (IOException e) {
            MAPLog.i(LOG_TAG, "Unable read from asset: " + e.getMessage());
        }
        finally {
            try {
                if (r != null) {
                    ((Reader)r).close();
                }
            }
            catch (IOException ex) {
                MAPLog.w(LOG_TAG, "Unable to close InputStreamReader: " + ex.getMessage());
            }
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                MAPLog.w(LOG_TAG, "Unable to close BufferedReader: " + ex.getMessage());
            }
        }
        return result;
    }

    public String getApiKey() {
        if (!this.isApiKeyInAssest()) {
            MAPLog.w(LOG_TAG, "Unable to get API Key from Assests");
            String apiKey = this.getStringValueFromMetaData(KEY_API_KEY);
            if (apiKey != null) {
                return apiKey;
            }
            return this.getStringValueFromMetaData(KEY_API_KEY_OLD);
        }
        return this._apiKey;
    }

    public boolean isApiKeyInAssest() {
        return this._apiKey != null;
    }

    private String getStringValueFromMetaData(String key) {
        String value = null;
        if (this._context != null) {
            MAPLog.i(LOG_TAG, "Attempting to parse API Key from meta data in Android manifest");
            try {
                ApplicationInfo appInfo = this._context.getPackageManager().getApplicationInfo(this._packageName, 128);
                if (appInfo.metaData != null) {
                    value = appInfo.metaData.getString(key);
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                MAPLog.w(LOG_TAG, "(key=" + key + ") " + e.getMessage());
            }
        }
        return value;
    }
}

