/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.dataobject;

import com.amazon.identity.auth.device.dataobject.AuthorizationToken;
import com.amazon.identity.auth.device.token.AccessAtzToken;
import com.amazon.identity.auth.device.token.RefreshAtzToken;

public final class AuthorizationTokenFactory {
    private AuthorizationTokenFactory() {
    }

    public static AuthorizationToken getAuthorizationToken(AuthorizationToken.AUTHZ_TOKEN_TYPE type) {
        AuthorizationToken token;
        switch (type) {
            case ACCESS: {
                token = new AccessAtzToken();
                break;
            }
            case REFRESH: {
                token = new RefreshAtzToken();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown token type for factory " + (Object)((Object)type));
            }
        }
        return token;
    }

    public static AuthorizationToken getCopyAuthorizationToken(AuthorizationToken token) {
        AuthorizationToken returnToken;
        switch (token.getTypeAsEnum()) {
            case ACCESS: {
                returnToken = new AccessAtzToken((AccessAtzToken)token);
                break;
            }
            case REFRESH: {
                returnToken = new RefreshAtzToken((RefreshAtzToken)token);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown token type for copy " + token.getType());
            }
        }
        return returnToken;
    }
}

