/*
 * Decompiled with CFR 0.152.
 */
package com.willblaschko.android.alexa;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Bundle;
import android.provider.Settings;
import android.util.Base64;
import android.util.Log;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.authorization.api.AmazonAuthorizationManager;
import com.amazon.identity.auth.device.authorization.api.AuthorizationListener;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.willblaschko.android.alexa.TokenManager;
import com.willblaschko.android.alexa.Util;
import com.willblaschko.android.alexa.callbacks.AsyncCallback;
import com.willblaschko.android.alexa.callbacks.AuthorizationCallback;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

public class AuthorizationManager {
    private static final String TAG = "AuthorizationHandler";
    private Context mContext;
    private String mProductId;
    private AmazonAuthorizationManager mAuthManager;
    private static final String[] APP_SCOPES = new String[]{"alexa:all"};
    private AuthorizationCallback mCallback;
    private static final String CODE_VERIFIER = "code_verifier";
    private AuthorizationListener authListener = new AuthorizationListener(){

        public void onSuccess(Bundle response) {
            String authCode = response.getString(AuthzConstants.BUNDLE_KEY.AUTHORIZATION_CODE.val);
            TokenManager.getAccessToken(AuthorizationManager.this.mContext, authCode, AuthorizationManager.this.getCodeVerifier(), AuthorizationManager.this.mAuthManager, new TokenManager.TokenResponseCallback(){

                @Override
                public void onSuccess(TokenManager.TokenResponse response) {
                    if (AuthorizationManager.this.mCallback != null) {
                        AuthorizationManager.this.mCallback.onSuccess();
                    }
                }

                @Override
                public void onFailure(Exception error) {
                    if (AuthorizationManager.this.mCallback != null) {
                        AuthorizationManager.this.mCallback.onError(error);
                    }
                }
            });
        }

        public void onError(AuthError ae) {
            if (AuthorizationManager.this.mCallback != null) {
                AuthorizationManager.this.mCallback.onError((Exception)ae);
            }
        }

        public void onCancel(Bundle cause) {
            if (AuthorizationManager.this.mCallback != null) {
                AuthorizationManager.this.mCallback.onCancel();
            }
        }
    };

    public AuthorizationManager(@NotNull Context context, @NotNull String productId) {
        this.mContext = context;
        this.mProductId = productId;
        try {
            this.mAuthManager = new AmazonAuthorizationManager(this.mContext, Bundle.EMPTY);
        }
        catch (IllegalArgumentException e) {
            Util.showAuthToast(this.mContext, "APIKey is incorrect or does not exist.");
            Log.e((String)TAG, (String)"Unable to Use Amazon Authorization Manager. APIKey is incorrect or does not exist. Does assets/api_key.txt exist in the main application?", (Throwable)e);
        }
    }

    public void checkLoggedIn(Context context, final AsyncCallback<Boolean, Throwable> callback) {
        TokenManager.getAccessToken(this.mAuthManager, context, new TokenManager.TokenCallback(){

            @Override
            public void onSuccess(String token) {
                callback.success(true);
            }

            @Override
            public void onFailure(Throwable e) {
                callback.success(false);
                callback.failure(e);
            }
        });
    }

    public void authorizeUser(AuthorizationCallback callback) {
        this.mCallback = callback;
        String PRODUCT_DSN = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
        Bundle options = new Bundle();
        String scope_data = "{\"alexa:all\":{\"productID\":\"" + this.mProductId + "\", \"productInstanceAttributes\":{\"deviceSerialNumber\":\"" + PRODUCT_DSN + "\"}}}";
        options.putString(AuthzConstants.BUNDLE_KEY.SCOPE_DATA.val, scope_data);
        options.putBoolean(AuthzConstants.BUNDLE_KEY.GET_AUTH_CODE.val, true);
        options.putString(AuthzConstants.BUNDLE_KEY.CODE_CHALLENGE.val, this.getCodeChallenge());
        options.putString(AuthzConstants.BUNDLE_KEY.CODE_CHALLENGE_METHOD.val, "S256");
        this.mAuthManager.authorize(APP_SCOPES, options, this.authListener);
    }

    private String getCodeVerifier() {
        if (Util.getPreferences(this.mContext).contains(CODE_VERIFIER)) {
            return Util.getPreferences(this.mContext).getString(CODE_VERIFIER, "");
        }
        String verifier = AuthorizationManager.createCodeVerifier();
        Util.getPreferences(this.mContext).edit().putString(CODE_VERIFIER, verifier).apply();
        return verifier;
    }

    private String getCodeChallenge() {
        String verifier = this.getCodeVerifier();
        return AuthorizationManager.base64UrlEncode(AuthorizationManager.getHash(verifier));
    }

    public static String createCodeVerifier() {
        char[] chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890".toCharArray();
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < 128; ++i) {
            char c = chars[random.nextInt(chars.length)];
            sb.append(c);
        }
        String verifier = sb.toString();
        return verifier;
    }

    public static String base64UrlEncode(byte[] arg) {
        String s = Base64.encodeToString((byte[])arg, (int)0);
        s = s.split("=")[0];
        s = s.replace('+', '-');
        s = s.replace('/', '_');
        return s;
    }

    public static byte[] getHash(String password) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        digest.reset();
        byte[] response = digest.digest(password.getBytes());
        return response;
    }

    public AmazonAuthorizationManager getAmazonAuthorizationManager() {
        return this.mAuthManager;
    }
}

