/*
 * Decompiled with CFR 0.152.
 */
package com.willblaschko.android.alexa.interfaces;

import android.util.Log;
import com.willblaschko.android.alexa.callbacks.AsyncCallback;
import com.willblaschko.android.alexa.interfaces.AvsException;
import com.willblaschko.android.alexa.interfaces.AvsResponse;
import com.willblaschko.android.alexa.interfaces.SendEvent;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class GenericSendEvent
extends SendEvent {
    public static final String TAG = "GenericSendEvent";
    String event;

    public GenericSendEvent(String url, String accessToken, String event, AsyncCallback<AvsResponse, Exception> callback) {
        this.event = event;
        if (callback != null) {
            callback.start();
        }
        try {
            this.prepareConnection(url, accessToken);
            if (callback != null) {
                callback.success(this.completePost());
                callback.complete();
            } else {
                this.completePost();
            }
            Log.i((String)TAG, (String)"Event sent");
        }
        catch (IOException e) {
            this.onError(callback, e);
        }
        catch (AvsException e) {
            this.onError(callback, e);
        }
        if (callback != null) {
            callback.complete();
        }
    }

    @Override
    @NotNull
    public String getEvent() {
        return this.event;
    }

    public void onError(AsyncCallback<AvsResponse, Exception> callback, Exception e) {
        if (callback != null) {
            callback.failure(e);
            callback.complete();
        }
    }
}

