/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.utils;

import java.security.InvalidParameterException;

public final class MAPVersionHelper {
    private static final String DELIMETER = "\\.";

    private MAPVersionHelper() {
    }

    public static String getVersionAsString(int[] version) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < version.length; ++i) {
            buffer.append(version[i]);
            buffer.append('.');
        }
        return buffer.substring(0, buffer.length() - 1);
    }

    public static int[] getVersionInfo(String version) {
        int[] versions;
        String[] splits = version.split(DELIMETER);
        if (splits.length >= 1) {
            versions = new int[splits.length];
            try {
                int i = 0;
                for (String versionInt : splits) {
                    versions[i++] = Integer.parseInt(versionInt);
                }
            }
            catch (NumberFormatException e) {
                throw new InvalidParameterException("getVersionInfo: version (" + version + ") must be in format of X[.X.X]... - where X must be an integer");
            }
        } else {
            throw new InvalidParameterException("version (" + version + ") must be in format of X.X.X");
        }
        return versions;
    }
}

