/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.authorization;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.appid.AppIdentifier;
import com.amazon.identity.auth.device.authorization.AmazonAuthorizationServiceInterface;
import com.amazon.identity.auth.device.authorization.ThirdPartyServiceHelper;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.datastore.DatabaseHelper;
import com.amazon.identity.auth.device.datastore.ProfileDataSource;
import com.amazon.identity.auth.device.endpoint.ServerCommunication;
import com.amazon.identity.auth.device.endpoint.TokenVendor;
import com.amazon.identity.auth.device.service.MAPServiceResult;
import com.amazon.identity.auth.device.shared.APIListener;
import com.amazon.identity.auth.device.utils.LWAServiceWrapper;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import java.util.Arrays;

public final class TokenHelper {
    private static final String LOG_TAG = TokenHelper.class.getName();
    private static TokenVendor mTokenVendor = new TokenVendor();
    private static ThirdPartyServiceHelper mThirdPartyServiceHelper = new ThirdPartyServiceHelper();

    private TokenHelper() {
    }

    static void setServerCommunicaton(ServerCommunication serverCommunication) {
        mTokenVendor.setServerCommunication(serverCommunication);
    }

    public static void getToken(Context context, final String packageName, final String clientId, final String[] scopes, APIListener listener, AppIdentifier appIdentifier, Bundle options) throws AuthError {
        MAPLog.pii(LOG_TAG, "GetToken pkg=" + packageName + " scopes=" + Arrays.toString(scopes), "clientId=" + clientId);
        AppInfo appInfo = appIdentifier.getAppInfo(packageName, context);
        if (appInfo == null) {
            MAPLog.e(LOG_TAG, "appInfo is null for " + packageName);
            listener.onError(new AuthError("APIKey info is unavailable for " + packageName, null, AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED));
            return;
        }
        final String directedId = null;
        try {
            final String appId = appInfo.getAppFamilyId();
            String authzToken = mTokenVendor.vendToken(directedId, scopes, context, options, appInfo);
            if (authzToken != null) {
                MAPLog.pii(LOG_TAG, "GetToken", "id=" + directedId + " appid=" + appInfo.getAppFamilyId() + " atzToken=" + authzToken);
                listener.onSuccess(MAPServiceResult.getOnSuccessBundle(AuthzConstants.BUNDLE_KEY.TOKEN.val, authzToken));
            } else {
                Bundle result = (Bundle)new LWAServiceWrapper<Bundle>(){

                    @Override
                    protected Bundle doWork(Context workContext, AmazonAuthorizationServiceInterface service) throws AuthError, RemoteException {
                        String tokenFromService = TokenHelper.getTokenFromService(workContext, directedId, clientId, appId, scopes, packageName, service);
                        return MAPServiceResult.getOnSuccessBundle(AuthzConstants.BUNDLE_KEY.TOKEN.val, tokenFromService);
                    }
                }.execute(context, mThirdPartyServiceHelper);
                if (result == null) {
                    result = new Bundle();
                }
                listener.onSuccess(result);
            }
        }
        catch (IOException e) {
            MAPLog.e(LOG_TAG, "" + e.getMessage(), e);
            listener.onError(new AuthError("Error communicating with server!", e, AuthError.ERROR_TYPE.ERROR_IO));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String getTokenFromService(Context context, String directedId, String clientId, String appId, String[] scopes, String packageName, AmazonAuthorizationServiceInterface service) throws AuthError, RemoteException {
        DatabaseHelper.clearAuthorizationState(context);
        ProfileDataSource.getInstance(context).deleteAllRows();
        Bundle result = service.getToken(null, packageName, scopes);
        if (result == null) return null;
        result.setClassLoader(context.getClassLoader());
        String tokenFromService = result.getString("accessAtzToken");
        if (!TextUtils.isEmpty((CharSequence)tokenFromService)) {
            return tokenFromService;
        }
        AuthError authError = (AuthError)result.getParcelable("AUTH_ERROR_EXECEPTION");
        if (authError == null) {
            MAPLog.i(LOG_TAG, "No results from service");
            return null;
        }
        if (AuthError.ERROR_TYPE.ERROR_INVALID_TOKEN == authError.getType()) {
            MAPLog.e(LOG_TAG, "Invalid token. Cleaning up.");
            ProfileDataSource.getInstance(context).deleteAllRows();
            return null;
        }
        MAPLog.i(LOG_TAG, "AuthError from service " + authError.getMessage());
        ThirdPartyServiceHelper.clearCachedService(context);
        throw authError;
    }

    static void setThirdPartyServiceHelper(ThirdPartyServiceHelper helper) {
        mThirdPartyServiceHelper = helper;
    }
}

